/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.protpa.models;

import java.util.Objects;
import java.util.UUID;
import me.bloodred.protpa.models.TeleportType;

public class TeleportRequest {
    private final UUID senderId;
    private final UUID targetId;
    private final TeleportType type;
    private final long timestamp;

    public TeleportRequest(UUID senderId, UUID targetId, TeleportType type) {
        this.senderId = senderId;
        this.targetId = targetId;
        this.type = type;
        this.timestamp = System.currentTimeMillis();
    }

    public UUID getSenderId() {
        return this.senderId;
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    public TeleportType getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeleportRequest that = (TeleportRequest)o;
        return this.timestamp == that.timestamp && Objects.equals(this.senderId, that.senderId) && Objects.equals(this.targetId, that.targetId) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.senderId, this.targetId, this.type, this.timestamp});
    }
}

