/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.hoverworth;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.jolly.hoverworth.Metrics;
import com.jolly.hoverworth.Scheduler;
import com.jolly.hoverworth.WorthFile;
import com.jolly.hoverworth.commands.Reload;
import com.jolly.hoverworth.integrations.EconomyShopGUI;
import com.jolly.hoverworth.listeners.WindowListener;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HoverWorth
extends JavaPlugin {
    private WorthFile worthFile;
    private EconomyShopGUI economyShopGUI;
    private Scheduler scheduler;
    public final Boolean debug = this.getConfig().getBoolean("debug", false);

    public void onLoad() {
        this.scheduler = new Scheduler(this);
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new WindowListener(this, this.scheduler), PacketListenerPriority.HIGHEST);
    }

    public void onEnable() {
        int pluginId = 27893;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        this.economyShopGUI = new EconomyShopGUI(this);
        PacketEvents.getAPI().init();
        this.worthFile = new WorthFile(this);
        this.saveDefaultConfig();
        this.getCommand("hwreload").setExecutor((CommandExecutor)new Reload(this));
        Bukkit.getPluginManager().registerEvents((Listener)new WindowListener(this, this.scheduler), (Plugin)this);
        this.getLogger().info("HoverWorth enabled \u2705");
        if (this.getConfig().getString("settings.integration").equalsIgnoreCase("EconomyShopGUI")) {
            this.economyShopGUI.loadESGUI();
            this.getLogger().info("EconomyShopGUI integration enabled \u2705");
            if (this.debug.booleanValue()) {
                Map<Material, List<EconomyShopGUI.ESGUIItem>> materials = this.economyShopGUI.esguiWorths;
                for (Map.Entry<Material, List<EconomyShopGUI.ESGUIItem>> entry : materials.entrySet()) {
                    Material mat = entry.getKey();
                    List<EconomyShopGUI.ESGUIItem> items = entry.getValue();
                    for (EconomyShopGUI.ESGUIItem item : items) {
                        if (mat == Material.OMINOUS_BOTTLE) {
                            this.getLogger().info(String.valueOf(mat) + " -> sell: " + item.sell + ", strength: " + item.ominousStrength);
                            continue;
                        }
                        if (mat == Material.POTION || mat == Material.SPLASH_POTION || mat == Material.LINGERING_POTION || mat == Material.TIPPED_ARROW) {
                            this.getLogger().info(String.valueOf(mat) + " -> sell: " + item.sell + (String)(item.potionTypes.isEmpty() ? "" : ", potion type(s): " + String.valueOf(item.potionTypes)));
                            continue;
                        }
                        if (!item.enchantments.isEmpty()) {
                            this.getLogger().info(String.valueOf(mat) + " -> sell: " + item.sell + ", enchantments: " + String.valueOf(item.enchantments));
                            continue;
                        }
                        this.getLogger().info(String.valueOf(mat) + " -> sell: " + item.sell);
                    }
                }
            }
            return;
        }
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }

    public WorthFile getWorthFile() {
        return this.worthFile;
    }

    public EconomyShopGUI getEconomyShopGUI() {
        return this.economyShopGUI;
    }
}

