/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.hoverworth;

import com.jolly.hoverworth.HoverWorth;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Scheduler {
    private final HoverWorth plugin;
    private final boolean folia;

    public Scheduler(HoverWorth plugin) {
        this.plugin = plugin;
        this.folia = this.isFolia();
    }

    private boolean isFolia() {
        try {
            return Bukkit.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]) != null;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private void ensureThreadSafe() {
        if (Bukkit.getServer().getClass().getName().contains("folia") && !this.folia) {
            throw new IllegalStateException("Folia detected but scheduler misidentified \u2014 check classloader or shading");
        }
    }

    public void runGlobal(Runnable task) {
        if (this.folia) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, task);
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, task);
        }
    }

    public void run(Player player, Runnable task) {
        if (this.folia) {
            Bukkit.getRegionScheduler().run((Plugin)this.plugin, player.getLocation(), t -> {
                if (!this.plugin.isEnabled() || !player.isOnline()) {
                    return;
                }
                task.run();
            });
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (!this.plugin.isEnabled() || !player.isOnline()) {
                    return;
                }
                task.run();
            });
        }
    }

    public Object runLater(Runnable task, long delayTicks) {
        this.ensureThreadSafe();
        if (this.folia) {
            return Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, t -> {
                if (!this.plugin.isEnabled()) {
                    return;
                }
                task.run();
            }, delayTicks);
        }
        return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!this.plugin.isEnabled()) {
                return;
            }
            task.run();
        }, delayTicks);
    }

    public Object runLater(Player player, Runnable task, long delayTicks) {
        if (delayTicks <= 0L) {
            delayTicks = 1L;
        }
        if (this.folia) {
            return player.getScheduler().runDelayed((Plugin)this.plugin, t -> {
                if (!this.plugin.isEnabled() || !player.isOnline()) {
                    return;
                }
                task.run();
            }, null, delayTicks);
        }
        return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!this.plugin.isEnabled() || !player.isOnline()) {
                return;
            }
            task.run();
        }, delayTicks);
    }

    public Object runTimer(Runnable task, long delayTicks, long periodTicks) {
        if (this.folia) {
            return Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, t -> {
                if (!this.plugin.isEnabled()) {
                    return;
                }
                task.run();
            }, delayTicks, periodTicks);
        }
        return Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task, delayTicks, periodTicks);
    }

    public void runAsync(Runnable task) {
        if (this.folia) {
            Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, t -> {
                if (!this.plugin.isEnabled()) {
                    return;
                }
                task.run();
            });
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
        }
    }

    public void runAsyncLater(Runnable task, long delayMillis) {
        if (this.folia) {
            Bukkit.getAsyncScheduler().runDelayed((Plugin)this.plugin, t -> {
                if (!this.plugin.isEnabled()) {
                    return;
                }
                task.run();
            }, delayMillis, TimeUnit.MILLISECONDS);
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
                if (!this.plugin.isEnabled()) {
                    return;
                }
                task.run();
            }, Math.max(1L, delayMillis / 50L));
        }
    }

    public void cancelTask(Object task) {
        if (task == null) {
            return;
        }
        if (task instanceof ScheduledTask) {
            ScheduledTask scheduled = (ScheduledTask)task;
            scheduled.cancel();
        } else if (task instanceof BukkitTask) {
            BukkitTask bukkitTask = (BukkitTask)task;
            bukkitTask.cancel();
        }
    }
}

