/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.hoverworth.integrations;

import com.jolly.hoverworth.HoverWorth;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class EconomyShopGUI {
    public Map<Material, List<ESGUIItem>> esguiWorths = new HashMap<Material, List<ESGUIItem>>();
    private static HoverWorth plugin;

    public EconomyShopGUI(HoverWorth plugin) {
        EconomyShopGUI.plugin = plugin;
    }

    public void loadESGUI() {
        File shopFolder = new File(Bukkit.getPluginManager().getPlugin("EconomyShopGUI").getDataFolder(), "shops");
        if (!shopFolder.exists()) {
            return;
        }
        for (File file : Objects.requireNonNull(shopFolder.listFiles((dir, name) -> name.endsWith(".yml")))) {
            YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
            ConfigurationSection pages = yml.getConfigurationSection("pages");
            if (pages == null) continue;
            for (String pageKey : pages.getKeys(false)) {
                ConfigurationSection items = pages.getConfigurationSection(pageKey + ".items");
                if (items == null) continue;
                for (String slotKey : items.getKeys(false)) {
                    double sell;
                    String sellPath;
                    Material material;
                    String matStr = yml.getString("pages." + pageKey + ".items." + slotKey + ".material");
                    if (matStr == null || (material = Material.matchMaterial((String)matStr)) == null || !yml.contains(sellPath = "pages." + pageKey + ".items." + slotKey + ".sell") || (sell = yml.getDouble(sellPath, 0.0)) <= 0.0) continue;
                    HashMap<String, Integer> enchants = new HashMap<String, Integer>();
                    String enchPath = "pages." + pageKey + ".items." + slotKey + ".enchantments";
                    if (yml.contains(enchPath)) {
                        for (String e : yml.getStringList(enchPath)) {
                            String[] parts = e.split(":");
                            if (parts.length != 2) continue;
                            try {
                                enchants.put(parts[0].trim(), Integer.parseInt(parts[1].trim()));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                    int ominousStrength = yml.getInt("pages." + pageKey + ".items." + slotKey + ".ominous-strength", 0);
                    List potionTypes = yml.getStringList("pages." + pageKey + ".items." + slotKey + ".potiontypes");
                    ESGUIItem esguiItem = new ESGUIItem(material, sell, enchants, ominousStrength, potionTypes);
                    this.esguiWorths.computeIfAbsent(material, k -> new ArrayList()).add(esguiItem);
                    for (List<ESGUIItem> list : this.esguiWorths.values()) {
                        list.sort((a, b) -> Integer.compare(b.enchantments.size(), a.enchantments.size()));
                    }
                }
            }
        }
    }

    public Double getESGUIItemWorth(Material item, ItemMeta meta) {
        Map itemEnchants;
        List<ESGUIItem> itemList = this.esguiWorths.get(item);
        if (itemList == null) {
            return null;
        }
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            itemEnchants = storageMeta.getStoredEnchants();
        } else {
            itemEnchants = meta.getEnchants();
        }
        for (ESGUIItem esguiItem : itemList) {
            boolean matches = true;
            if (!esguiItem.enchantments.isEmpty()) {
                for (Map.Entry<String, Integer> required : esguiItem.enchantments.entrySet()) {
                    boolean hasEnch = itemEnchants.entrySet().stream().anyMatch(e -> ((Enchantment)e.getKey()).getKey().getKey().equalsIgnoreCase((String)required.getKey()) && e.getValue() == required.getValue());
                    if (hasEnch) continue;
                    matches = false;
                    break;
                }
                if (matches && itemEnchants.size() != esguiItem.enchantments.size()) {
                    matches = false;
                }
            }
            if (matches && item == Material.OMINOUS_BOTTLE && esguiItem.ominousStrength > 0) {
                int actualStrength = -1;
                try {
                    Method getStrength = meta.getClass().getDeclaredMethod("getAmplifier", new Class[0]);
                    getStrength.setAccessible(true);
                    Object result = getStrength.invoke((Object)meta, new Object[0]);
                    if (result instanceof Integer) {
                        Integer i = (Integer)result;
                        actualStrength = i;
                    }
                }
                catch (InvocationTargetException e2) {
                    actualStrength = 0;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (actualStrength + 1 != esguiItem.ominousStrength) {
                    matches = false;
                }
            }
            if (matches && (item == Material.POTION || item == Material.SPLASH_POTION || item == Material.LINGERING_POTION || item == Material.TIPPED_ARROW) && !esguiItem.potionTypes.isEmpty() && meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                List<String> potionTypes = esguiItem.potionTypes;
                boolean potionMatch = false;
                String key = Objects.requireNonNull(potionMeta.getBasePotionType()).name().toUpperCase();
                for (PotionEffect effect : potionMeta.getBasePotionType().getPotionEffects()) {
                    int amp = effect.getAmplifier();
                    int dur = effect.getDuration();
                    if (EconomyShopGUI.plugin.debug.booleanValue()) {
                        plugin.getLogger().info("Name: " + key + " Amplifier: " + amp + " Duration: " + dur);
                    }
                    if (!potionTypes.stream().anyMatch(t -> {
                        if (EconomyShopGUI.plugin.debug.booleanValue()) {
                            plugin.getLogger().info("Type: " + t + " Match: " + key);
                        }
                        return t.equalsIgnoreCase(key);
                    })) continue;
                    potionMatch = true;
                    break;
                }
                if (!potionMatch) {
                    matches = false;
                }
            }
            if (!matches) continue;
            if (EconomyShopGUI.plugin.debug.booleanValue()) {
                plugin.getLogger().info(String.valueOf(esguiItem.material) + " -> " + esguiItem.sell);
            }
            return esguiItem.sell;
        }
        return null;
    }

    public static class ESGUIItem {
        public Material material;
        public double sell;
        public Map<String, Integer> enchantments;
        public int ominousStrength;
        public List<String> potionTypes;

        public ESGUIItem(Material material, double sell, Map<String, Integer> enchantments, int ominousStrength, List<String> potionTypes) {
            this.material = material;
            this.sell = sell;
            this.enchantments = enchantments != null ? enchantments : new HashMap();
            this.ominousStrength = ominousStrength;
            this.potionTypes = potionTypes != null ? potionTypes : new ArrayList();
        }
    }
}

