/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.hoverworth.listeners;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.item.type.ItemType;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import com.jolly.hoverworth.HoverWorth;
import com.jolly.hoverworth.Scheduler;
import com.jolly.hoverworth.integrations.EconomyShopGUI;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class WindowListener
implements PacketListener,
Listener {
    private final HoverWorth plugin;
    private final String symbol;
    private final Scheduler scheduler;
    private static final NamespacedKey WORTH_NBT_KEY = new NamespacedKey("hoverworth", "worth");
    private final ThreadLocal<Boolean> fixingInventory = ThreadLocal.withInitial(() -> false);
    MiniMessage mm = MiniMessage.miniMessage();

    public WindowListener(HoverWorth plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.symbol = plugin.getConfig().getString("settings.currency-symbol", "$");
    }

    public void onPacketSend(PacketSendEvent event) {
        int windowId;
        WrapperPlayServerWindowItems wrapper;
        if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
            wrapper = new WrapperPlayServerWindowItems(event);
            windowId = wrapper.getWindowId();
            if (!this.isVanillaInventory(windowId, event)) {
                return;
            }
            List items = wrapper.getItems();
            if (items == null) {
                return;
            }
            for (int i = 0; i < items.size(); ++i) {
                com.github.retrooper.packetevents.protocol.item.ItemStack packetItem = (com.github.retrooper.packetevents.protocol.item.ItemStack)items.get(i);
                if (packetItem == null || packetItem.isEmpty()) continue;
                Material mat = SpigotConversionUtil.toBukkitItemMaterial((ItemType)packetItem.getType());
                if (this.plugin.getEconomyShopGUI() == null) {
                    return;
                }
                Map<Material, List<EconomyShopGUI.ESGUIItem>> esgui = this.plugin.getEconomyShopGUI().esguiWorths;
                if (esgui == null || !esgui.containsKey(mat)) continue;
                items.set(i, this.addLore(packetItem));
            }
            wrapper.setItems(items);
        }
        if (event.getPacketType() == PacketType.Play.Server.SET_SLOT) {
            wrapper = new WrapperPlayServerSetSlot(event);
            windowId = wrapper.getWindowId();
            if (!this.isVanillaInventory(windowId, event)) {
                return;
            }
            com.github.retrooper.packetevents.protocol.item.ItemStack packetItem = wrapper.getItem();
            if (packetItem == null || packetItem.isEmpty()) {
                return;
            }
            if (this.plugin.getEconomyShopGUI() == null) {
                return;
            }
            Material mat = SpigotConversionUtil.toBukkitItemMaterial((ItemType)packetItem.getType());
            Map<Material, List<EconomyShopGUI.ESGUIItem>> esgui = this.plugin.getEconomyShopGUI().esguiWorths;
            if (esgui == null || !esgui.containsKey(mat)) {
                return;
            }
            wrapper.setItem(this.addLore(packetItem));
            if (windowId == 0) {
                Player player = (Player)event.getPlayer();
                this.scheduler.runLater(() -> this.fixInventory(player), 2L);
                this.fixingInventory.set(false);
            }
        }
    }

    public void fixInventory(Player player) {
        if (this.fixingInventory.get().booleanValue()) {
            return;
        }
        this.fixingInventory.set(true);
        try {
            this.scheduler.runLater(() -> {
                PlayerInventory inv = player.getInventory();
                boolean changed = false;
                for (int i = 0; i < inv.getSize(); ++i) {
                    ItemMeta meta;
                    ItemStack item = inv.getItem(i);
                    if (item == null || item.getType() == Material.AIR || (meta = item.getItemMeta()) == null || meta.getPersistentDataContainer().has(WORTH_NBT_KEY, PersistentDataType.DOUBLE)) continue;
                    inv.setItem(i, this.addLoreBukkit(item));
                    changed = true;
                }
                if (changed) {
                    player.updateInventory();
                }
            }, 10L);
        }
        catch (Exception e) {
            this.fixingInventory.set(false);
            throw e;
        }
    }

    private boolean isVanillaInventory(int windowId, PacketSendEvent event) {
        Player player = (Player)event.getPlayer();
        if (windowId == 0) {
            return true;
        }
        InventoryView view = player.getOpenInventory();
        if (view == null) {
            return false;
        }
        InventoryType type = view.getType();
        String title = ChatColor.stripColor((String)view.getTitle()).toLowerCase();
        if (this.isCustomTitle(title)) {
            return false;
        }
        return switch (type) {
            case InventoryType.CHEST, InventoryType.ENDER_CHEST, InventoryType.BARREL, InventoryType.HOPPER, InventoryType.FURNACE, InventoryType.BLAST_FURNACE, InventoryType.SMOKER, InventoryType.ANVIL, InventoryType.BEACON, InventoryType.BREWING, InventoryType.DISPENSER, InventoryType.DROPPER, InventoryType.SHULKER_BOX -> true;
            default -> false;
        };
    }

    private boolean isCustomTitle(String title) {
        String[] vanillaTitles;
        if (title == null || title.isEmpty()) {
            return true;
        }
        for (String v : vanillaTitles = new String[]{"chest", "large chest", "ender chest", "furnace", "blast furnace", "smoker", "anvil", "hopper", "beacon", "brewing stand", "dispenser", "dropper", "shulker box", "barrel", "crafting"}) {
            if (!title.equals(v)) continue;
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemPickup(PlayerAttemptPickupItemEvent event) {
        Double existing;
        if (event.isCancelled()) {
            return;
        }
        ItemStack item = event.getItem().getItemStack();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && (existing = (Double)meta.getPersistentDataContainer().get(WORTH_NBT_KEY, PersistentDataType.DOUBLE)) != null) {
            return;
        }
        ItemStack modified = this.addLoreBukkit(item);
        event.getItem().setItemStack(modified);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        ItemStack item = event.getEntity().getItemStack();
        ItemStack modified = this.addLoreBukkit(item);
        event.getEntity().setItemStack(modified);
    }

    private com.github.retrooper.packetevents.protocol.item.ItemStack addLore(com.github.retrooper.packetevents.protocol.item.ItemStack packetItem) {
        if (packetItem == null || packetItem.isEmpty()) {
            return packetItem;
        }
        ItemStack bukkitItem = SpigotConversionUtil.toBukkitItemStack((com.github.retrooper.packetevents.protocol.item.ItemStack)packetItem);
        ItemStack updated = this.addLoreBukkit(bukkitItem);
        return SpigotConversionUtil.fromBukkitItemStack((ItemStack)updated);
    }

    private ItemStack addLoreBukkit(ItemStack bukkitItem) {
        if (bukkitItem == null || bukkitItem.getType() == Material.AIR) {
            return bukkitItem;
        }
        ItemStack clone = bukkitItem.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            return clone;
        }
        Material item = clone.getType();
        String itemKey = item.name().toUpperCase();
        Double worth = null;
        if ("EconomyShopGUI".equalsIgnoreCase(this.plugin.getConfig().getString("settings.integration", "none")) && this.plugin.getEconomyShopGUI() != null) {
            worth = this.plugin.getEconomyShopGUI().getESGUIItemWorth(item, meta);
        }
        if (worth == null && this.plugin.getWorthFile().get().contains(itemKey)) {
            worth = this.plugin.getWorthFile().get().getDouble(itemKey + ".worth");
        }
        if (worth == null) {
            return clone;
        }
        Double existing = (Double)meta.getPersistentDataContainer().get(WORTH_NBT_KEY, PersistentDataType.DOUBLE);
        if (existing != null && Math.abs(existing - worth) < 1.0E-4) {
            return clone;
        }
        meta.getPersistentDataContainer().set(WORTH_NBT_KEY, PersistentDataType.DOUBLE, (Object)worth);
        List<Component> lore = meta.lore() != null ? new ArrayList<Component>(meta.lore()) : new ArrayList();
        lore = this.updateWorthLine(lore, worth, this.symbol);
        meta.lore(lore);
        this.addDescriptionLine(meta, lore, itemKey);
        clone.setItemMeta(meta);
        return clone;
    }

    private List<Component> updateWorthLine(List<Component> lore, double worth, String symbol) {
        String template = this.plugin.getConfig().getString("settings.lore-message", "<white>Worth: <gold>{currency-symbol}{worth}<white>/pc");
        Component worthLine = this.mm.deserialize((Object)template.replace("{currency-symbol}", symbol).replace("{worth}", String.valueOf(worth))).decoration(TextDecoration.ITALIC, false);
        String[] segments = template.split("\\{[^}]+}");
        List<String> literals = Arrays.stream(segments).map(s -> s.replaceAll("<[^>]+>", "").trim()).filter(s -> !s.isEmpty()).toList();
        lore.removeIf(line -> {
            String plain = PlainTextComponentSerializer.plainText().serialize(line);
            return literals.stream().anyMatch(plain::contains);
        });
        lore.addFirst(worthLine);
        return lore;
    }

    private void addDescriptionLine(ItemMeta meta, List<Component> lore, String itemKey) {
        String desc = this.plugin.getWorthFile().get().getString(itemKey + ".description", "");
        if (desc.isEmpty()) {
            return;
        }
        String plainDesc = PlainTextComponentSerializer.plainText().serialize(this.mm.deserialize((Object)desc)).trim();
        boolean hasDesc = lore.stream().map(line -> PlainTextComponentSerializer.plainText().serialize(line).trim()).anyMatch(lineText -> lineText.equalsIgnoreCase(plainDesc));
        if (hasDesc) {
            return;
        }
        Component descLine = this.mm.deserialize((Object)desc);
        if (!desc.contains("<italic>") && !desc.contains("<i>")) {
            descLine = descLine.decoration(TextDecoration.ITALIC, false);
        }
        lore.addLast(descLine);
        meta.lore(lore);
    }
}

