/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashwarp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.hedgetech.slashwarp.data.LocationData;
import org.hedgetech.slashwarp.saveddata.WarpSavedData;

public class Warp {
    private static final HashSet<String> RESERVED_NAMES = new HashSet<String>(){
        {
            this.add("add");
            this.add("back");
            this.add("del");
            this.add("list");
            this.add("top");
        }
    };
    private static final HashMap<UUID, LocationData> PREVIOUS_LOCATIONS = new HashMap();

    public static int addWarp(CommandSourceStack source, String name) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            MinecraftServer server = source.getServer();
            WarpSavedData state = WarpSavedData.ofServer(server);
            Map<String, LocationData> warps = state.getWarps();
            if (warps.containsKey(name)) {
                source.sendSuccess(() -> Component.literal((String)"A warp location with that name already exists."), false);
            } else if (RESERVED_NAMES.contains(name)) {
                source.sendSuccess(() -> Component.literal((String)"Unable to save warp to a reserved name."), false);
            } else {
                LocationData loc = new LocationData((ResourceKey<Level>)player.level().dimension(), player.position(), player.getYRot(), player.getXRot());
                warps.put(name, loc);
                source.sendSuccess(() -> Component.literal((String)("Successfully added warp location: " + name)), false);
            }
        }
        return 1;
    }

    public static int delWarp(CommandSourceStack source, String name) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            MinecraftServer server = source.getServer();
            WarpSavedData state = WarpSavedData.ofServer(server);
            Map<String, LocationData> warps = state.getWarps();
            if (warps.containsKey(name)) {
                warps.remove(name);
                source.sendSuccess(() -> Component.literal((String)("Successfully removed warp locations: " + name)), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)"A warp location with that names does not exist."), false);
            }
        }
        return 1;
    }

    public static int listWarps(CommandSourceStack source) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            MinecraftServer server = source.getServer();
            WarpSavedData state = WarpSavedData.ofServer(server);
            StringBuilder warpList = new StringBuilder();
            state.getWarps().forEach((name, loc) -> {
                String str = "\n" + name + ": " + loc.toString();
                warpList.append(str);
            });
            source.sendSuccess(() -> Component.literal((String)warpList.toString()), false);
        }
        return 1;
    }

    private static BlockPos findSafeTop(Level world, BlockPos playerPos, int maxRadius, int verticalScan) {
        BlockPos start = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, playerPos);
        BlockPos safe = Warp.scanDownwards(world, start, verticalScan);
        if (safe != null) {
            return safe;
        }
        for (int r = 1; r <= maxRadius; ++r) {
            for (BlockPos candidate : Warp.spiralAround(playerPos, r)) {
                BlockPos top = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, candidate);
                BlockPos found = Warp.scanDownwards(world, top, verticalScan);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    private static List<BlockPos> spiralAround(BlockPos center, int radius) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int cx = center.getX();
        int cz = center.getZ();
        for (int r = 1; r <= radius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                positions.add(new BlockPos(cx + dx, center.getY(), cz - r));
                positions.add(new BlockPos(cx + dx, center.getY(), cz + r));
            }
            for (int dz = -r + 1; dz <= r - 1; ++dz) {
                positions.add(new BlockPos(cx - r, center.getY(), cz + dz));
                positions.add(new BlockPos(cx + r, center.getY(), cz + dz));
            }
        }
        return positions;
    }

    private static BlockPos scanDownwards(Level world, BlockPos top, int depth) {
        BlockPos.MutableBlockPos cursor = top.mutable();
        for (int dy = 0; dy < depth; ++dy) {
            if (Warp.isSafeSpot(world, (BlockPos)cursor)) {
                return cursor.immutable();
            }
            cursor.move(Direction.DOWN);
        }
        return null;
    }

    private static boolean isSafeSpot(Level world, BlockPos pos) {
        boolean feetOk;
        BlockPos feet = pos.above();
        BlockPos head = feet.above();
        BlockState floor = world.getBlockState(pos);
        BlockState feetState = world.getBlockState(feet);
        BlockState headState = world.getBlockState(head);
        if (floor.getCollisionShape((BlockGetter)world, pos, CollisionContext.empty()).isEmpty()) {
            return false;
        }
        if (floor.is(Blocks.CACTUS) || floor.is(Blocks.MAGMA_BLOCK) || floor.is(Blocks.CAMPFIRE) || floor.is(Blocks.SOUL_CAMPFIRE) || floor.is(Blocks.FIRE) || floor.is(Blocks.LAVA) || floor.is(Blocks.POWDER_SNOW)) {
            return false;
        }
        if (feetState.getFluidState().is(FluidTags.LAVA)) {
            return false;
        }
        if (feetState.is(Blocks.POWDER_SNOW)) {
            return false;
        }
        boolean bl = feetOk = feetState.isAir() || feetState.getFluidState().is(FluidTags.WATER);
        if (!feetOk) {
            return false;
        }
        return headState.isAir() && headState.getCollisionShape((BlockGetter)world, head, CollisionContext.empty()).isEmpty();
    }

    public static int warpTo(CommandSourceStack source, String name) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            MinecraftServer server = source.getServer();
            WarpSavedData state = WarpSavedData.ofServer(server);
            Map<String, LocationData> warps = state.getWarps();
            LocationData previousLocation = Warp.getPlayerPreviousLocation(player.getUUID());
            if (warps.containsKey(name) || name.equals("back") && previousLocation != null || name.equals("top")) {
                String result;
                LocationData loc;
                Set relatives = Set.of();
                if (name.equals("back")) {
                    loc = previousLocation;
                } else if (name.equals("top")) {
                    BlockPos safePos = Warp.findSafeTop((Level)player.level(), player.blockPosition(), 8, 8);
                    if (safePos == null) {
                        source.sendSuccess(() -> Component.literal((String)"Failed to find a safe position at the top."), false);
                        return 1;
                    }
                    loc = new LocationData((ResourceKey<Level>)player.level().dimension(), safePos.above().getCenter(), player.getYRot(), player.getXRot());
                } else {
                    loc = warps.get(name);
                }
                ServerLevel world = server.getLevel(loc.getWorld());
                Vec3 position = loc.getPosition();
                if (!player.position().closerThan((Position)position, 2.0)) {
                    Warp.setPlayerPreviousLocation(player.getUUID(), new LocationData((ResourceKey<Level>)player.level().dimension(), player.position(), player.getYRot(), player.getXRot()));
                }
                if (world == null) {
                    source.sendSuccess(() -> Component.literal((String)"Unable to warp from no where."), false);
                    return 1;
                }
                List pets = world.getEntities(EntityTypeTest.forClass(TamableAnimal.class), animal -> animal.isTame() && animal.isOwnedBy((LivingEntity)player) && !animal.isOrderedToSit());
                boolean success = false;
                if (player.isPassenger()) {
                    Entity vehicle = player.getVehicle();
                    if (vehicle != null) {
                        success = vehicle.teleportTo(world, position.x, position.y + 0.5, position.z, relatives, loc.getYaw(), loc.getPitch(), false);
                        success = success && vehicle.hasPassenger((Entity)player);
                    }
                } else {
                    success = player.teleportTo(world, position.x, position.y, position.z, relatives, loc.getYaw(), loc.getPitch(), false);
                }
                if (!pets.isEmpty()) {
                    pets.forEach(TamableAnimal::tryToTeleportToOwner);
                }
                String string = result = success ? "Successfully warped" : "Failed to warp";
                if (name.equals("back")) {
                    source.sendSuccess(() -> Component.literal((String)(result + " back to previous location.")), false);
                } else if (name.equals("top")) {
                    source.sendSuccess(() -> Component.literal((String)(result + " to the top.")), false);
                } else {
                    source.sendSuccess(() -> Component.literal((String)(result + " to: " + name)), false);
                }
            } else {
                source.sendSuccess(() -> Component.literal((String)"This warp location doesn't appear to exist."), false);
            }
        }
        return 1;
    }

    private static LocationData getPlayerPreviousLocation(UUID playerUuid) {
        return PREVIOUS_LOCATIONS.getOrDefault(playerUuid, null);
    }

    private static void setPlayerPreviousLocation(UUID playerUuid, LocationData location) {
        PREVIOUS_LOCATIONS.put(playerUuid, location);
    }

    public static void clearPlayerPreviousLocation(UUID playerUuid) {
        PREVIOUS_LOCATIONS.remove(playerUuid);
    }
}

