/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashwarp.saveddata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.hedgetech.slashwarp.data.LocationData;

public class WarpSavedData
extends SavedData {
    public static final Codec<Map<String, LocationData>> WARP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, LocationData.CODEC);
    public static final Codec<WarpSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WARP_CODEC.fieldOf("warps").forGetter(WarpSavedData::getWarps)).apply((Applicative)instance, WarpSavedData::new));
    private final HashMap<String, LocationData> warps = new HashMap();
    private static final SavedDataType<WarpSavedData> TYPE = new SavedDataType("slashwarp", WarpSavedData::new, CODEC, null);

    public WarpSavedData() {
    }

    public WarpSavedData(Map<String, LocationData> warps) {
        this.warps.putAll(warps);
    }

    public Map<String, LocationData> getWarps() {
        return this.warps;
    }

    public static WarpSavedData ofServer(MinecraftServer server) {
        try {
            WarpSavedData state = (WarpSavedData)Objects.requireNonNull(server.overworld()).getDataStorage().computeIfAbsent(TYPE);
            state.setDirty();
            return state;
        }
        catch (Exception e) {
            DimensionDataStorage dataStore = Objects.requireNonNull(server.overworld()).getDataStorage();
            dataStore.set(TYPE, (SavedData)new WarpSavedData());
            WarpSavedData state = (WarpSavedData)dataStore.computeIfAbsent(TYPE);
            state.setDirty();
            return state;
        }
    }
}

