/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashwarp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import org.hedgetech.slashwarp.data.LocationData;
import org.hedgetech.slashwarp.saveddata.WarpSavedData;

public class Warp {
    private static final HashSet<String> RESERVED_NAMES = new HashSet<String>(){
        {
            this.add("add");
            this.add("back");
            this.add("del");
            this.add("list");
        }
    };
    private static final HashMap<UUID, LocationData> PREVIOUS_LOCATIONS = new HashMap();

    public static int addWarp(CommandSourceStack source, String name) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            MinecraftServer server = source.getServer();
            WarpSavedData state = WarpSavedData.ofServer(server);
            Map<String, LocationData> warps = state.getWarps();
            if (warps.containsKey(name)) {
                source.sendSuccess(() -> Component.literal((String)"A warp location with that name already exists."), false);
            } else if (RESERVED_NAMES.contains(name)) {
                source.sendSuccess(() -> Component.literal((String)"Unable to save warp to a reserved name."), false);
            } else {
                LocationData loc = new LocationData((ResourceKey<Level>)player.level().dimension(), player.position(), player.getYRot(), player.getXRot());
                warps.put(name, loc);
                source.sendSuccess(() -> Component.literal((String)("Successfully added warp location: " + name)), false);
            }
        }
        return 1;
    }

    public static int delWarp(CommandSourceStack source, String name) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            MinecraftServer server = source.getServer();
            WarpSavedData state = WarpSavedData.ofServer(server);
            Map<String, LocationData> warps = state.getWarps();
            if (warps.containsKey(name)) {
                warps.remove(name);
                source.sendSuccess(() -> Component.literal((String)("Successfully removed warp locations: " + name)), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)"A warp location with that names does not exist."), false);
            }
        }
        return 1;
    }

    public static int listWarps(CommandSourceStack source) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            MinecraftServer server = source.getServer();
            WarpSavedData state = WarpSavedData.ofServer(server);
            StringBuilder warpList = new StringBuilder();
            state.getWarps().forEach((name, loc) -> {
                String str = "\n" + name + ": " + loc.toString();
                warpList.append(str);
            });
            source.sendSuccess(() -> Component.literal((String)warpList.toString()), false);
        }
        return 1;
    }

    public static int warpTo(CommandSourceStack source, String name) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            MinecraftServer server = source.getServer();
            WarpSavedData state = WarpSavedData.ofServer(server);
            Map<String, LocationData> warps = state.getWarps();
            LocationData previousLocation = Warp.getPlayerPreviousLocation(player.getUUID());
            if (warps.containsKey(name) || name.equals("back") && previousLocation != null) {
                String result;
                Set relatives = Set.of();
                LocationData loc = name.equals("back") ? previousLocation : warps.get(name);
                ServerLevel world = server.getLevel(loc.getWorld());
                Vec3 position = loc.getPosition();
                if (!player.position().closerThan((Position)position, 2.0)) {
                    Warp.setPlayerPreviousLocation(player.getUUID(), new LocationData((ResourceKey<Level>)player.level().dimension(), player.position(), player.getYRot(), player.getXRot()));
                }
                if (world == null) {
                    source.sendSuccess(() -> Component.literal((String)"Unable to warp from no where."), false);
                    return 1;
                }
                List pets = world.getEntities(EntityTypeTest.forClass(TamableAnimal.class), animal -> animal.isTame() && animal.isOwnedBy((LivingEntity)player) && !animal.isOrderedToSit());
                boolean success = false;
                if (player.isPassenger()) {
                    Entity vehicle = player.getVehicle();
                    if (vehicle != null) {
                        success = vehicle.teleportTo(world, position.x, position.y + 0.5, position.z, relatives, loc.getYaw(), loc.getPitch(), false);
                        success = success && vehicle.hasPassenger((Entity)player);
                    }
                } else {
                    success = player.teleportTo(world, position.x, position.y, position.z, relatives, loc.getYaw(), loc.getPitch(), false);
                }
                if (!pets.isEmpty()) {
                    pets.forEach(TamableAnimal::tryToTeleportToOwner);
                }
                String string = result = success ? "Successfully warped" : "Failed to warp";
                if (name.equals("back")) {
                    source.sendSuccess(() -> Component.literal((String)(result + " back to previous location.")), false);
                } else {
                    source.sendSuccess(() -> Component.literal((String)(result + " to: " + name)), false);
                }
            } else {
                source.sendSuccess(() -> Component.literal((String)"This warp location doesn't appear to exist."), false);
            }
        }
        return 1;
    }

    private static LocationData getPlayerPreviousLocation(UUID playerUuid) {
        return PREVIOUS_LOCATIONS.getOrDefault(playerUuid, null);
    }

    private static void setPlayerPreviousLocation(UUID playerUuid, LocationData location) {
        PREVIOUS_LOCATIONS.put(playerUuid, location);
    }

    public static void clearPlayerPreviousLocation(UUID playerUuid) {
        PREVIOUS_LOCATIONS.remove(playerUuid);
    }
}

