/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashwarp.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LocationData {
    public static final Codec<LocationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("world").forGetter(LocationData::getWorldLocationString), (App)Vec3.CODEC.fieldOf("position").forGetter(LocationData::getPosition), (App)Codec.FLOAT.fieldOf("yaw").forGetter(LocationData::getYaw), (App)Codec.FLOAT.fieldOf("pitch").forGetter(LocationData::getPitch)).apply((Applicative)instance, LocationData::new));
    private ResourceKey<Level> world;
    private Vec3 position;
    private float yaw;
    private float pitch;

    public LocationData() {
    }

    public LocationData(ResourceKey<Level> world, Vec3 position, float yaw, float pitch) {
        this.world = world;
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public LocationData(String world, Vec3 position, float yaw, float pitch) {
        this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)world));
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public String toString() {
        DecimalFormat numFormat = new DecimalFormat("0.00");
        return "[" + String.valueOf(this.world.location()) + "] (" + numFormat.format(this.position.x) + ", " + numFormat.format(this.position.y) + ", " + numFormat.format(this.position.z) + ")";
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }

    public String getWorldLocationString() {
        return this.world.location().toString();
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }
}

