# Marca al jugador como alguien que está usando una cámara
tag @s add Player.UUID.Camera
tag @s add Spectator.Camera

# Inicializa el contador global UniversalUUID si aún no existe
execute unless score #PlayerGeneral UniversalUUID matches -2147483648.. run scoreboard players set #PlayerGeneral UniversalUUID -2147483648

# Si el jugador no tiene UUID asignado, genera uno nuevo incrementando el global
execute unless score @s UniversalUUID matches -2147483648.. store result score @s UniversalUUID run scoreboard players add #PlayerGeneral UniversalUUID 1

# Guarda en storage la UUID de la cámara seleccionada en el ítem del jugador
execute store result storage camera:player UUID double 1 run data get entity @s SelectedItem.components."minecraft:custom_data".Cam6

# Teletransporta al jugador a la cámara Cam6 usando los datos del storage
function camera:camera/teleport/cams/cam6 with storage camera:player

# Marca al jugador como la cámara 0, y elimina marcas de otras cámaras
tag @s[tag=!NotCamera] remove Cam0.Player
tag @s[tag=!NotCamera] remove Cam1.Player
tag @s[tag=!NotCamera] remove Cam2.Player
tag @s[tag=!NotCamera] remove Cam3.Player
tag @s[tag=!NotCamera] remove Cam4.Player
tag @s[tag=!NotCamera] remove Cam5.Player
tag @s[tag=!NotCamera] add Cam6.Player
tag @s[tag=!NotCamera] remove Cam7.Player
tag @s[tag=!NotCamera] remove Cam8.Player
tag @s[tag=!NotCamera] remove Cam9.Player

# Coldown
execute unless score @s Coldown matches 1.. run scoreboard players set @s Coldown 1

# Ejecuta la función correspondiente según la cámara seleccionada
execute if entity @s[tag=Cam1.Player] run function camera:camera/teleport/click1
execute if entity @s[tag=Cam2.Player] run function camera:camera/teleport/click2
execute if entity @s[tag=Cam3.Player] run function camera:camera/teleport/click3
execute if entity @s[tag=Cam4.Player] run function camera:camera/teleport/click4
execute if entity @s[tag=Cam5.Player] run function camera:camera/teleport/click5
execute if entity @s[tag=Cam0.Player] run function camera:camera/teleport/click0
execute if entity @s[tag=Cam7.Player] run function camera:camera/teleport/click7
execute if entity @s[tag=Cam8.Player] run function camera:camera/teleport/click8
execute if entity @s[tag=Cam9.Player] run function camera:camera/teleport/click9

# En caso que el jugador esté montado monta al maniqui al veiculo donde está el jugador
execute on vehicle run ride @s mount @n[tag=Profile.Maniquin]

# Muestra el nombre de la cámara actual si está en Cam6
title @s[tag=Cam6.Player] actionbar {text:"Cam6",bold:1b}

# Forceload en la posición del maniquí para mantener cargado el chunk
execute as @e[tag=Profile.Maniquin] at @s run forceload add ~ ~

# Copia el UUID del jugador cámara desde el scoreboard al valor del maniquí
execute as @e[tag=Profile.Maniquin] at @s store result score @s UniversalUUID run scoreboard players get @p[tag=Player.UUID.Camera] UniversalUUID

# Limpieza de tags temporales
tag @s remove Player.UUID.Camera
tag @e remove Profile.Maniquin

# Resetea el selector de cámara después del clic
scoreboard players reset @s Camera.Selector

# Limpia el tag que evita que se reasignen cámaras
tag @s remove NotCamera
