/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.cache;

import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Location;

public class BlockSourceCache {
    private static final BlockSourceCache INSTANCE = BlockSourceCache.createMedium();
    private static final long CLEANUP_INTERVAL_MILLIS = 60000L;
    private final Map<LocationCache, CacheEntry> cache;
    private final long expiryMillis;
    private long lastCleanupTime;

    public BlockSourceCache(int initialCapacity, int expiryMinutes) {
        this.cache = new HashMap<LocationCache, CacheEntry>(initialCapacity);
        this.expiryMillis = (long)expiryMinutes * 60000L;
        this.lastCleanupTime = System.currentTimeMillis();
    }

    public static Long getPlayerId(Location location) {
        CacheEntry entry = INSTANCE.get(LocationCache.of(location));
        if (entry != null) {
            return entry.playerId;
        }
        return null;
    }

    public static void registerBlockSource(@Nullable Location newLocation, long playerId) {
        if (newLocation == null) {
            return;
        }
        INSTANCE.put(LocationCache.of(newLocation), playerId, newLocation);
    }

    public static void registerBlockSource(@Nullable Location sourceKey, long playerId, @Nullable Location newLocation) {
        if (newLocation == null) {
            return;
        }
        if (sourceKey == null) {
            BlockSourceCache.registerBlockSource(newLocation, playerId);
            return;
        }
        INSTANCE.put(LocationCache.of(sourceKey), playerId, newLocation);
    }

    public static void removeBlockSource(Location location) {
        INSTANCE.remove(LocationCache.of(location));
    }

    public static void cleanup() {
        INSTANCE.cleanupExpired();
    }

    public static BlockSourceCache createSmall() {
        return new BlockSourceCache(2048, 10);
    }

    public static BlockSourceCache createMedium() {
        return new BlockSourceCache(4096, 10);
    }

    public static BlockSourceCache createLarge() {
        return new BlockSourceCache(8192, 10);
    }

    public static BlockSourceCache createXLarge() {
        return new BlockSourceCache(16384, 10);
    }

    private CacheEntry put(LocationCache sourceKey, long playerId, Location location) {
        return this.put(sourceKey, playerId, location.getBlockX(), location.getBlockY(), location.getBlockZ(), sourceKey.getWorldId());
    }

    private CacheEntry put(LocationCache sourceKey, long playerId, int x, int y, int z, int worldId) {
        long now = System.currentTimeMillis();
        if (now - this.lastCleanupTime > 60000L) {
            this.cleanupExpired();
            this.lastCleanupTime = now;
        }
        CacheEntry entry = new CacheEntry(playerId, x, y, z, worldId);
        this.cache.put(sourceKey, entry);
        return entry;
    }

    private CacheEntry get(LocationCache sourceKey) {
        CacheEntry entry = this.cache.get(sourceKey);
        if (entry != null) {
            entry.lastAccessTime = System.currentTimeMillis();
        }
        return entry;
    }

    private void cleanupExpired() {
        long now = System.currentTimeMillis();
        long threshold = now - this.expiryMillis;
        this.cache.entrySet().removeIf(entry -> ((CacheEntry)entry.getValue()).lastAccessTime < threshold);
    }

    private void remove(LocationCache sourceKey) {
        this.cache.remove(sourceKey);
    }

    private static class CacheEntry {
        final long playerId;
        final int x;
        final int y;
        final int z;
        final int worldId;
        long lastAccessTime;

        CacheEntry(long playerId, int x, int y, int z, int worldId) {
            this.playerId = playerId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.worldId = worldId;
            this.lastAccessTime = System.currentTimeMillis();
        }
    }
}

