/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.data.RestoreSession;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RestoreSessionArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        String action;
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null || playerProtect.getRestoreSession() == null) {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noActiveRestoreSession");
            return;
        }
        RestoreSession session = playerProtect.getRestoreSession();
        if (arguments.length == 0) {
            return;
        }
        switch (action = arguments[0].toLowerCase()) {
            case "restore": {
                if (arguments.length <= 1) break;
                this.plugin.getRestoreSessionManager().restoreIndividualLog(session, Integer.parseInt(arguments[1]));
                break;
            }
            case "undo": {
                if (arguments.length <= 1) break;
                this.plugin.getRestoreSessionManager().undoIndividualRestore(session, Integer.parseInt(arguments[1]));
                break;
            }
            case "restoreall": {
                this.plugin.getRestoreSessionManager().restoreAllVisible(session);
                break;
            }
            case "next": {
                this.plugin.getRestoreSessionManager().nextPage(session);
                break;
            }
            case "exit": {
                this.plugin.getRestoreSessionManager().exitSession(session);
            }
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        return Arrays.asList("restore", "undo", "restoreall", "next", "exit");
    }
}

