/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.utils.SerializerUtils;
import java.sql.ResultSet;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.entity.Entity;

public class PlayerKillLogEntry
extends LogEntry {
    private final String entityType;
    private final EntityData entityData;

    public PlayerKillLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.entityType = jsonObject.get("et").getAsString();
        this.entityData = jsonObject.has("ed") ? (EntityData)SerializerUtils.getGson().fromJson(jsonObject.get("ed").getAsString(), EntityData.class) : new EntityData();
    }

    public PlayerKillLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.entityType = jsonObject.get("et").getAsString();
        this.entityData = jsonObject.has("ed") ? (EntityData)SerializerUtils.getGson().fromJson(jsonObject.get("ed").getAsString(), EntityData.class) : new EntityData();
    }

    public PlayerKillLogEntry(long playerId, Entity killed, ActionType actionType) {
        super(playerId, actionType.getId(), killed.getLocation(), System.currentTimeMillis());
        this.entityType = killed.getType().name();
        this.entityData = new EntityData(StellarProtect.getInstance().getDataEntity(killed).getData());
    }

    @Override
    public String getDataString() {
        return this.entityType;
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerKillLogEntry entry = this;
        obj.addProperty("et", entry.getEntityType());
        if (!this.entityData.getEntityData().isEmpty()) {
            obj.addProperty("ed", SerializerUtils.getGson().toJson((Object)this.entityData, EntityData.class));
        }
        return obj.toString();
    }

    @Generated
    public String getEntityType() {
        return this.entityType;
    }

    @Generated
    public EntityData getEntityData() {
        return this.entityData;
    }

    public static class EntityData {
        private final HashMap<String, Object> entityData;

        public EntityData() {
            this.entityData = new HashMap();
        }

        public EntityData(HashMap<String, Object> entityData) {
            this.entityData = entityData;
        }

        @Generated
        public HashMap<String, Object> getEntityData() {
            return this.entityData;
        }
    }
}

