/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.entity.Entity;

public class PlayerTameEntry
extends LogEntry {
    private final String entityUUID;
    private final String entityType;

    public PlayerTameEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.entityUUID = jsonObject.get("eu").getAsString();
        this.entityType = jsonObject.get("et").getAsString();
    }

    public PlayerTameEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.entityUUID = jsonObject.get("eu").getAsString();
        this.entityType = jsonObject.get("et").getAsString();
    }

    public PlayerTameEntry(long playerId, Entity tamed) {
        super(playerId, ActionType.TAME.getId(), tamed.getLocation(), System.currentTimeMillis());
        this.entityType = tamed.getType().name();
        this.entityUUID = tamed.getUniqueId().toString();
    }

    @Override
    public String toSaveJson() {
        return "{\"eu\":\"" + this.entityUUID + "\",\"et\":\"" + this.entityType + "\"}";
    }

    @Generated
    public String getEntityUUID() {
        return this.entityUUID;
    }

    @Generated
    public String getEntityType() {
        return this.entityType;
    }
}

