/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs;

import io.github.insideranh.stellarprotect.libs.bson.Transformer;
import io.github.insideranh.stellarprotect.libs.bson.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonTypeClassMap;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.ContainerCodecHelper;
import io.github.insideranh.stellarprotect.libs.bson.codecs.MapCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.ParameterizedMapCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecConfigurationException;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecProvider;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MapCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public MapCodecProvider() {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public MapCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public MapCodecProvider(Transformer valueTransformer) {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, valueTransformer);
    }

    public MapCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = valueTransformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.get(clazz, Collections.emptyList(), registry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> typeArguments, CodecRegistry registry) {
        if (Map.class.isAssignableFrom(clazz)) {
            int typeArgumentsSize = typeArguments.size();
            switch (typeArgumentsSize) {
                case 0: {
                    MapCodec<T> result = new MapCodec<T>(registry, this.bsonTypeClassMap, this.valueTransformer, clazz);
                    return result;
                }
                case 2: {
                    Type genericTypeOfMapKey = typeArguments.get(0);
                    if (!genericTypeOfMapKey.getTypeName().equals("java.lang.String")) {
                        throw new CodecConfigurationException("Unsupported key type for Map: " + genericTypeOfMapKey.getTypeName());
                    }
                    ParameterizedMapCodec result = new ParameterizedMapCodec(ContainerCodecHelper.getCodec(registry, typeArguments.get(1)), clazz);
                    return result;
                }
            }
            throw new CodecConfigurationException("Expected two parameterized type for an Iterable, but found " + typeArgumentsSize);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapCodecProvider that = (MapCodecProvider)o;
        if (!this.bsonTypeClassMap.equals(that.bsonTypeClassMap)) {
            return false;
        }
        return Objects.equals(this.valueTransformer, that.valueTransformer);
    }

    public int hashCode() {
        int result = this.bsonTypeClassMap.hashCode();
        result = 31 * result + (this.valueTransformer != null ? this.valueTransformer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MapCodecProvider{}";
    }
}

