/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb;

import io.github.insideranh.stellarprotect.libs.mongodb.SubjectProvider;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.ThreadSafe;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.Locks;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Logger;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Loggers;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.NonNull;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

@ThreadSafe
public class KerberosSubjectProvider
implements SubjectProvider {
    private static final Logger LOGGER = Loggers.getLogger("authenticator");
    private static final String TGT_PREFIX = "krbtgt/";
    private final ReentrantLock lock = new ReentrantLock();
    private String loginContextName;
    private String fallbackLoginContextName;
    private Subject subject;

    public KerberosSubjectProvider() {
        this("com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate");
    }

    public KerberosSubjectProvider(String loginContextName) {
        this(loginContextName, null);
    }

    private KerberosSubjectProvider(String loginContextName, @Nullable String fallbackLoginContextName) {
        this.loginContextName = Assertions.notNull("loginContextName", loginContextName);
        this.fallbackLoginContextName = fallbackLoginContextName;
    }

    @Override
    @NonNull
    public Subject getSubject() throws LoginException {
        return Locks.checkedWithInterruptibleLock(this.lock, () -> {
            if (this.subject == null || KerberosSubjectProvider.needNewSubject(this.subject)) {
                this.subject = this.createNewSubject();
            }
            return this.subject;
        });
    }

    private Subject createNewSubject() throws LoginException {
        LoginContext loginContext;
        try {
            LOGGER.debug(String.format("Creating LoginContext with name '%s'", this.loginContextName));
            loginContext = new LoginContext(this.loginContextName);
        }
        catch (LoginException e) {
            if (this.fallbackLoginContextName == null) {
                throw e;
            }
            LOGGER.debug(String.format("Creating LoginContext with fallback name '%s'", this.fallbackLoginContextName));
            loginContext = new LoginContext(this.fallbackLoginContextName);
            this.loginContextName = this.fallbackLoginContextName;
            this.fallbackLoginContextName = null;
        }
        loginContext.login();
        LOGGER.debug("Login successful");
        return loginContext.getSubject();
    }

    private static boolean needNewSubject(Subject subject) {
        for (KerberosTicket cur : subject.getPrivateCredentials(KerberosTicket.class)) {
            if (!cur.getServer().getName().startsWith(TGT_PREFIX)) continue;
            if (System.currentTimeMillis() <= cur.getEndTime().getTime() - TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES)) break;
            LOGGER.info("The TGT is close to expiring. Time to reacquire.");
            return true;
        }
        return false;
    }
}

