/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonDocumentCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;
import io.github.insideranh.stellarprotect.libs.bson.json.JsonWriter;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoInternalException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoServerException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.ExceptionUtils;
import java.io.StringWriter;

public class MongoCommandException
extends MongoServerException {
    private static final long serialVersionUID = 8160676451944215078L;
    private final BsonDocument response;

    public MongoCommandException(BsonDocument response, ServerAddress address) {
        super(ExceptionUtils.MongoCommandExceptionUtils.extractErrorCode(response), ExceptionUtils.MongoCommandExceptionUtils.extractErrorCodeName(response), String.format("Command failed with error %s: '%s' on server %s. The full response is %s", MongoCommandException.extractErrorCodeAndName(response), MongoCommandException.extractErrorMessage(response), address, MongoCommandException.getResponseAsJson(response)), address);
        this.response = response;
        this.addLabels(ExceptionUtils.MongoCommandExceptionUtils.extractErrorLabelsAsBson(response));
    }

    public int getErrorCode() {
        return this.getCode();
    }

    @Override
    public String getErrorCodeName() {
        return super.getErrorCodeName();
    }

    public String getErrorMessage() {
        return MongoCommandException.extractErrorMessage(this.response);
    }

    public BsonDocument getResponse() {
        return this.response;
    }

    private static String getResponseAsJson(BsonDocument commandResponse) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(writer);
        new BsonDocumentCodec().encode((BsonWriter)jsonWriter, commandResponse, EncoderContext.builder().build());
        return writer.toString();
    }

    private static String extractErrorCodeAndName(BsonDocument response) {
        int errorCode = ExceptionUtils.MongoCommandExceptionUtils.extractErrorCode(response);
        String errorCodeName = ExceptionUtils.MongoCommandExceptionUtils.extractErrorCodeName(response);
        if (errorCodeName.isEmpty()) {
            return Integer.toString(errorCode);
        }
        return String.format("%d (%s)", errorCode, errorCodeName);
    }

    private static String extractErrorMessage(BsonDocument response) {
        String errorMessage = response.getString("errmsg", new BsonString("")).getValue();
        if (errorMessage == null) {
            throw new MongoInternalException("This value should not be null");
        }
        return errorMessage;
    }
}

