/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.mongodb.AutoEncryptionSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.ClientEncryptionSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClient;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClients;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.CollectionInfoRetriever;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.CommandMarker;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.Crypt;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.KeyManagementService;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.KeyRetriever;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.capi.MongoCryptHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.crypt.capi.MongoCrypt;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.crypt.capi.MongoCryptOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.crypt.capi.MongoCrypts;
import java.util.Map;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(MongoClientSettings mongoClientSettings, AutoEncryptionSettings settings) {
        MongoClient sharedInternalClient = null;
        MongoClientSettings keyVaultMongoClientSettings = settings.getKeyVaultMongoClientSettings();
        if (keyVaultMongoClientSettings == null || !settings.isBypassAutoEncryption()) {
            MongoClientSettings defaultInternalMongoClientSettings = MongoClientSettings.builder(mongoClientSettings).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            sharedInternalClient = MongoClients.create(defaultInternalMongoClientSettings);
        }
        MongoClient keyVaultClient = keyVaultMongoClientSettings == null ? sharedInternalClient : MongoClients.create(keyVaultMongoClientSettings);
        MongoCrypt mongoCrypt = MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings));
        return new Crypt(mongoCrypt, Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers(), settings.isBypassAutoEncryption(), settings.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(sharedInternalClient), new CommandMarker(mongoCrypt, settings), sharedInternalClient, keyVaultClient);
    }

    static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings settings) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings)), Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers());
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap) {
        return new KeyManagementService(kmsProviderSslContextMap, 10000);
    }

    private Crypts() {
    }
}

