/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql;

import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Beta;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Reason;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Sealed;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.Branches;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.BranchesTerminal;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlArray;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlBoolean;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlEntry;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlString;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlValue;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlValues;
import java.util.function.Function;

@Sealed
@Beta(value={Reason.CLIENT})
public interface MqlMap<T extends MqlValue>
extends MqlValue {
    public MqlBoolean has(MqlString var1);

    default public MqlBoolean has(String key) {
        Assertions.notNull("key", key);
        return this.has(MqlValues.of(key));
    }

    public T get(MqlString var1);

    default public T get(String key) {
        Assertions.notNull("key", key);
        return this.get(MqlValues.of(key));
    }

    public T get(MqlString var1, T var2);

    default public T get(String key, T other) {
        Assertions.notNull("key", key);
        Assertions.notNull("other", other);
        return this.get(MqlValues.of(key), other);
    }

    public MqlMap<T> set(MqlString var1, T var2);

    default public MqlMap<T> set(String key, T value) {
        Assertions.notNull("key", key);
        Assertions.notNull("value", value);
        return this.set(MqlValues.of(key), value);
    }

    public MqlMap<T> unset(MqlString var1);

    default public MqlMap<T> unset(String key) {
        Assertions.notNull("key", key);
        return this.unset(MqlValues.of(key));
    }

    public MqlMap<T> merge(MqlMap<? extends T> var1);

    public MqlArray<MqlEntry<T>> entries();

    public <R extends MqlDocument> R asDocument();

    public <R extends MqlValue> R passMapTo(Function<? super MqlMap<T>, ? extends R> var1);

    public <R extends MqlValue> R switchMapOn(Function<Branches<MqlMap<T>>, ? extends BranchesTerminal<MqlMap<T>, ? extends R>> var1);
}

