/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonBinaryWriter;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.FieldNameValidator;
import io.github.insideranh.stellarprotect.libs.bson.io.BsonOutput;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.BsonWriterHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ByteBufferBsonOutput;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MessageSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OpCode;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicInteger;

abstract class RequestMessage {
    static final AtomicInteger REQUEST_ID = new AtomicInteger(1);
    static final int MESSAGE_PROLOGUE_LENGTH = 16;
    private final String collectionName;
    private final MessageSettings settings;
    private final int id;
    private final OpCode opCode;
    private EncodingMetadata encodingMetadata;

    public static int getCurrentGlobalId() {
        return REQUEST_ID.get();
    }

    RequestMessage(OpCode opCode, int requestId, MessageSettings settings) {
        this(null, opCode, requestId, settings);
    }

    RequestMessage(String collectionName, OpCode opCode, MessageSettings settings) {
        this(collectionName, opCode, REQUEST_ID.getAndIncrement(), settings);
    }

    private RequestMessage(@Nullable String collectionName, OpCode opCode, int requestId, MessageSettings settings) {
        this.collectionName = collectionName;
        this.settings = settings;
        this.id = requestId;
        this.opCode = opCode;
    }

    public int getId() {
        return this.id;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public MessageSettings getSettings() {
        return this.settings;
    }

    public void encode(ByteBufferBsonOutput bsonOutput, OperationContext operationContext) {
        Assertions.notNull("operationContext", operationContext);
        int messageStartPosition = bsonOutput.getPosition();
        this.writeMessagePrologue(bsonOutput);
        EncodingMetadata encodingMetadata = this.encodeMessageBodyWithMetadata(bsonOutput, operationContext);
        BsonWriterHelper.backpatchLength(messageStartPosition, bsonOutput);
        this.encodingMetadata = encodingMetadata;
    }

    public EncodingMetadata getEncodingMetadata() {
        return this.encodingMetadata;
    }

    protected void writeMessagePrologue(BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.id);
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.opCode.getValue());
    }

    protected abstract EncodingMetadata encodeMessageBodyWithMetadata(ByteBufferBsonOutput var1, OperationContext var2);

    protected int writeDocument(BsonDocument document, BsonOutput bsonOutput, FieldNameValidator validator) {
        BsonBinaryWriter writer = BsonWriterHelper.createBsonBinaryWriter(bsonOutput, validator, this.getSettings());
        int documentStart = bsonOutput.getPosition();
        BsonWriterHelper.encodeUsingRegistry(writer, document);
        return bsonOutput.getPosition() - documentStart;
    }

    protected String getCollectionName() {
        return this.collectionName;
    }

    static class EncodingMetadata {
        private final int firstDocumentPosition;

        EncodingMetadata(int firstDocumentPosition) {
            this.firstDocumentPosition = firstDocumentPosition;
        }

        public int getFirstDocumentPosition() {
            return this.firstDocumentPosition;
        }
    }
}

