/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt64;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.FieldNameValidator;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Collation;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.WriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncWriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandResultDocumentCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.DocumentHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.FindAndModifyHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.OperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.session.SessionContext;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;

public abstract class BaseFindAndModifyOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final Decoder<T> decoder;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private Collation collation;
    private BsonDocument hint;
    private String hintString;
    private BsonValue comment;
    private BsonDocument variables;

    protected BaseFindAndModifyOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(WriteBinding binding) {
        return SyncOperationHelper.executeRetryableWrite(binding, this.getDatabaseName(), null, this.getFieldNameValidator(), CommandResultDocumentCodec.create(this.getDecoder(), "value"), this.getCommandCreator(), FindAndModifyHelper.transformer(), cmd -> cmd);
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<T> callback) {
        AsyncOperationHelper.executeRetryableWriteAsync(binding, this.getDatabaseName(), null, this.getFieldNameValidator(), CommandResultDocumentCodec.create(this.getDecoder(), "value"), this.getCommandCreator(), FindAndModifyHelper.asyncTransformer(), cmd -> cmd, callback);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public BaseFindAndModifyOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public BaseFindAndModifyOperation<T> projection(@Nullable BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public BaseFindAndModifyOperation<T> sort(@Nullable BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    @Nullable
    public BsonDocument getHint() {
        return this.hint;
    }

    public BaseFindAndModifyOperation<T> hint(@Nullable BsonDocument hint) {
        this.hint = hint;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public BaseFindAndModifyOperation<T> hintString(@Nullable String hint) {
        this.hintString = hint;
        return this;
    }

    public BaseFindAndModifyOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public BaseFindAndModifyOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public BsonDocument getLet() {
        return this.variables;
    }

    public BaseFindAndModifyOperation<T> let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    protected abstract FieldNameValidator getFieldNameValidator();

    protected abstract void specializeCommand(BsonDocument var1, ConnectionDescription var2);

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            SessionContext sessionContext = operationContext.getSessionContext();
            BsonDocument commandDocument = new BsonDocument("findAndModify", new BsonString(this.getNamespace().getCollectionName()));
            DocumentHelper.putIfNotNull(commandDocument, "query", this.getFilter());
            DocumentHelper.putIfNotNull(commandDocument, "fields", this.getProjection());
            DocumentHelper.putIfNotNull(commandDocument, "sort", this.getSort());
            this.specializeCommand(commandDocument, connectionDescription);
            if (this.getWriteConcern().isAcknowledged() && !this.getWriteConcern().isServerDefault() && !sessionContext.hasActiveTransaction()) {
                commandDocument.put("writeConcern", this.getWriteConcern().asDocument());
            }
            if (this.getCollation() != null) {
                commandDocument.put("collation", this.getCollation().asDocument());
            }
            if (this.getHint() != null || this.getHintString() != null) {
                OperationHelper.validateHintForFindAndModify(connectionDescription, this.getWriteConcern());
                if (this.getHint() != null) {
                    commandDocument.put("hint", this.getHint());
                } else {
                    commandDocument.put("hint", new BsonString(this.getHintString()));
                }
            }
            DocumentHelper.putIfNotNull(commandDocument, "comment", this.getComment());
            DocumentHelper.putIfNotNull(commandDocument, "let", this.getLet());
            if (OperationHelper.isRetryableWrite(this.isRetryWrites(), this.getWriteConcern(), connectionDescription, sessionContext)) {
                commandDocument.put("txnNumber", new BsonInt64(sessionContext.advanceTransactionNumber()));
            }
            return commandDocument;
        };
    }

    private String getDatabaseName() {
        return this.getNamespace().getDatabaseName();
    }
}

