/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.WriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncWriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.OperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteConcernHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;

public class RenameCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace originalNamespace;
    private final MongoNamespace newNamespace;
    private final WriteConcern writeConcern;
    private boolean dropTarget;

    public RenameCollectionOperation(MongoNamespace originalNamespace, MongoNamespace newNamespace, @Nullable WriteConcern writeConcern) {
        this.originalNamespace = Assertions.notNull("originalNamespace", originalNamespace);
        this.newNamespace = Assertions.notNull("newNamespace", newNamespace);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isDropTarget() {
        return this.dropTarget;
    }

    public RenameCollectionOperation dropTarget(boolean dropTarget) {
        this.dropTarget = dropTarget;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return SyncOperationHelper.withConnection(binding, connection -> SyncOperationHelper.executeCommand(binding, "admin", this.getCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer(binding.getOperationContext().getTimeoutContext())));
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                AsyncOperationHelper.executeCommandAsync(binding, "admin", this.getCommand(), Assertions.assertNotNull(connection), AsyncOperationHelper.writeConcernErrorTransformerAsync(binding.getOperationContext().getTimeoutContext()), AsyncOperationHelper.releasingCallback(errHandlingCallback, connection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("renameCollection", new BsonString(this.originalNamespace.getFullName())).append("to", new BsonString(this.newNamespace.getFullName())).append("dropTarget", BsonBoolean.valueOf(this.dropTarget));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

