/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.blocks.BlockTemplate;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.managers.BlocksManager;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class PlayerBlockLogEntry
extends LogEntry {
    private static final BlocksManager blocksManager = StellarProtect.getInstance().getBlocksManager();
    private final int blockId;
    private String nexoBlockId;
    private byte extraType;
    private String extraData;

    public PlayerBlockLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.blockId = this.getBlockId(jsonObject);
        if (jsonObject.has("nbId")) {
            this.nexoBlockId = jsonObject.get("nbId").getAsString();
        }
        if (jsonObject.has("xt")) {
            this.extraType = jsonObject.get("xt").getAsByte();
        }
        if (jsonObject.has("xd")) {
            this.extraData = jsonObject.get("xd").getAsString();
        }
    }

    public PlayerBlockLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.blockId = this.getBlockId(jsonObject);
        if (jsonObject.has("nbId")) {
            this.nexoBlockId = jsonObject.get("nbId").getAsString();
        }
    }

    public PlayerBlockLogEntry(long playerId, BlockState blockState, ActionType actionType) {
        super(playerId, actionType.getId(), blockState.getLocation(), System.currentTimeMillis());
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(blockState);
        this.blockId = itemTemplate.getId();
    }

    public PlayerBlockLogEntry(long playerId, Location location, Block block, ActionType actionType) {
        super(playerId, actionType.getId(), location, System.currentTimeMillis());
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(block);
        this.blockId = itemTemplate.getId();
    }

    public PlayerBlockLogEntry(long playerId, Block block, ActionType actionType) {
        super(playerId, actionType.getId(), block.getLocation(), System.currentTimeMillis());
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(block);
        this.blockId = itemTemplate.getId();
    }

    public PlayerBlockLogEntry(long playerId, Block block, ActionType actionType, String nexoBlockId) {
        super(playerId, actionType.getId(), block.getLocation(), System.currentTimeMillis());
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(block);
        this.blockId = itemTemplate.getId();
        this.nexoBlockId = "nexo:" + nexoBlockId;
    }

    public int getBlockId(JsonObject jsonObject) {
        if (jsonObject.has("b")) {
            return jsonObject.get("b").getAsInt();
        }
        if (!jsonObject.has("d")) {
            return -1;
        }
        String data = jsonObject.get("d").getAsString();
        BlockTemplate blockTemplate = blocksManager.getBlockTemplate(data);
        return blockTemplate.getId();
    }

    @Override
    public String getDataString() {
        if (this.nexoBlockId != null) {
            return this.nexoBlockId;
        }
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(this.blockId);
        return itemTemplate.getDataBlock().getBlockDataString();
    }

    @Override
    public String toSaveJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("b", (Number)this.blockId);
        if (this.nexoBlockId != null) {
            jsonObject.addProperty("nbId", this.nexoBlockId);
        }
        if (this.extraType != 0) {
            jsonObject.addProperty("xt", (Number)this.extraType);
        }
        if (this.extraData != null) {
            jsonObject.addProperty("xd", this.extraData);
        }
        return jsonObject.toString();
    }

    @Generated
    public int getBlockId() {
        return this.blockId;
    }

    @Generated
    public String getNexoBlockId() {
        return this.nexoBlockId;
    }

    @Generated
    public byte getExtraType() {
        return this.extraType;
    }

    @Generated
    public String getExtraData() {
        return this.extraData;
    }
}

