/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs.configuration;

import io.github.insideranh.stellarprotect.libs.bson.UuidRepresentation;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecProvider;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.MapOfCodecsProvider;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.OverridableUuidRepresentationCodecProvider;
import io.github.insideranh.stellarprotect.libs.bson.internal.ProvidersCodecRegistry;
import java.util.Arrays;
import java.util.List;

public final class CodecRegistries {
    public static CodecRegistry withUuidRepresentation(CodecRegistry codecRegistry, UuidRepresentation uuidRepresentation) {
        return CodecRegistries.fromProviders(new OverridableUuidRepresentationCodecProvider(codecRegistry, uuidRepresentation));
    }

    public static CodecRegistry fromCodecs(Codec<?> ... codecs) {
        return CodecRegistries.fromCodecs(Arrays.asList(codecs));
    }

    public static CodecRegistry fromCodecs(List<? extends Codec<?>> codecs) {
        return CodecRegistries.fromProviders(new MapOfCodecsProvider(codecs));
    }

    public static CodecRegistry fromProviders(CodecProvider ... providers) {
        return CodecRegistries.fromProviders(Arrays.asList(providers));
    }

    public static CodecRegistry fromProviders(List<? extends CodecProvider> providers) {
        return new ProvidersCodecRegistry(providers);
    }

    public static CodecRegistry fromRegistries(CodecRegistry ... registries) {
        return CodecRegistries.fromRegistries(Arrays.asList(registries));
    }

    public static CodecRegistry fromRegistries(List<? extends CodecRegistry> registries) {
        return new ProvidersCodecRegistry(registries);
    }

    private CodecRegistries() {
    }
}

