/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.foliascheduler;

import io.github.insideranh.stellarprotect.libs.foliascheduler.AsyncSchedulerImplementation;
import io.github.insideranh.stellarprotect.libs.foliascheduler.EntitySchedulerImplementation;
import io.github.insideranh.stellarprotect.libs.foliascheduler.GlobalSchedulerImplementation;
import io.github.insideranh.stellarprotect.libs.foliascheduler.RegionSchedulerImplementation;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public interface ServerImplementation {
    @NotNull
    public Plugin getOwningPlugin();

    public boolean isOwnedByCurrentRegion(@NotNull Location var1);

    public boolean isOwnedByCurrentRegion(@NotNull Location var1, int var2);

    public boolean isOwnedByCurrentRegion(@NotNull Block var1);

    public boolean isOwnedByCurrentRegion(@NotNull World var1, int var2, int var3);

    public boolean isOwnedByCurrentRegion(@NotNull World var1, int var2, int var3, int var4);

    public boolean isOwnedByCurrentRegion(@NotNull Entity var1);

    @NotNull
    public GlobalSchedulerImplementation global();

    @NotNull
    public AsyncSchedulerImplementation async();

    @NotNull
    public EntitySchedulerImplementation entity(@NotNull Entity var1);

    @NotNull
    public RegionSchedulerImplementation region(@NotNull World var1, int var2, int var3);

    @NotNull
    default public RegionSchedulerImplementation region(@NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Location world cannot be null");
        }
        return this.region(world, location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @NotNull
    default public RegionSchedulerImplementation region(@NotNull Block block) {
        return this.region(block.getWorld(), block.getX() >> 4, block.getZ() >> 4);
    }

    @NotNull
    default public RegionSchedulerImplementation region(@NotNull Chunk chunk) {
        return this.region(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public void cancelTasks();

    @NotNull
    default public CompletableFuture<Boolean> teleportAsync(@NotNull Entity entity, @NotNull Location location) {
        return this.teleportAsync(entity, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @NotNull
    public CompletableFuture<Boolean> teleportAsync(@NotNull Entity var1, @NotNull Location var2, @NotNull PlayerTeleportEvent.TeleportCause var3);
}

