/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.foliascheduler.mappingio.format;

import io.github.insideranh.stellarprotect.libs.foliascheduler.mappingio.format.tiny.Tiny2Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ColumnFileReader
implements Closeable {
    private final Reader reader;
    private final char columnSeparator;
    private char[] buffer = new char[16384];
    private int bufferPos;
    private int bufferLimit;
    private int mark = -1;
    private int lineNumber = 1;
    private boolean eol;
    private boolean eof;
    private int markedLineNumber;
    private boolean markedEol;
    private boolean markedEof;

    public ColumnFileReader(Reader reader, char columnSeparator) {
        this.reader = reader;
        this.columnSeparator = columnSeparator;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public boolean nextCol(String expect) throws IOException {
        if (this.eol) {
            return false;
        }
        int len = expect.length();
        if (!this.fillBuffer(len)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[this.bufferPos + i] == expect.charAt(i)) continue;
            return false;
        }
        char trailing = '\u0000';
        if (this.fillBuffer(len + 1) && (trailing = this.buffer[this.bufferPos + len]) != this.columnSeparator && trailing != '\n' && trailing != '\r') {
            return false;
        }
        this.bufferPos += expect.length();
        if (trailing == this.columnSeparator) {
            ++this.bufferPos;
        } else {
            this.eol = true;
        }
        return true;
    }

    @Nullable
    public String nextCol() throws IOException {
        return this.nextCol(false);
    }

    @Nullable
    public String nextEscapedCol() throws IOException {
        return this.nextCol(true);
    }

    @Nullable
    public String nextCol(boolean unescape) throws IOException {
        int start;
        int firstEscaped;
        int end;
        block11: {
            if (this.eol) {
                return null;
            }
            end = this.bufferPos;
            firstEscaped = -1;
            while (true) {
                if (end < this.bufferLimit) {
                    char c = this.buffer[end];
                    if (c == this.columnSeparator || c == '\n' || c == '\r') {
                        start = this.bufferPos;
                        this.bufferPos = end;
                        if (c == this.columnSeparator) {
                            ++this.bufferPos;
                        } else {
                            this.eol = true;
                        }
                        break block11;
                    }
                    if (unescape && c == '\\' && firstEscaped < 0) {
                        firstEscaped = this.bufferPos;
                    }
                    ++end;
                    continue;
                }
                int oldStart = this.bufferPos;
                boolean filled = this.fillBuffer(end - this.bufferPos + 1);
                int posShift = this.bufferPos - oldStart;
                assert (posShift <= 0);
                end += posShift;
                if (firstEscaped >= 0) {
                    firstEscaped += posShift;
                }
                if (!filled) break;
            }
            start = this.bufferPos;
            this.bufferPos = end;
            this.eol = true;
        }
        int len = end - start;
        if (len == 0) {
            return "";
        }
        if (firstEscaped >= 0) {
            return Tiny2Util.unescape(String.valueOf(this.buffer, start, len));
        }
        return String.valueOf(this.buffer, start, len);
    }

    @Nullable
    public String nextCols(boolean unescape) throws IOException {
        if (this.eol) {
            return null;
        }
        int end = this.bufferPos;
        int firstEscaped = -1;
        while (true) {
            if (end < this.bufferLimit) {
                char c = this.buffer[end];
                if (c == '\n' || c == '\r') break;
                if (unescape && c == '\\' && firstEscaped < 0) {
                    firstEscaped = this.bufferPos;
                }
                ++end;
                continue;
            }
            int oldStart = this.bufferPos;
            boolean filled = this.fillBuffer(end - this.bufferPos + 1);
            int posShift = this.bufferPos - oldStart;
            assert (posShift <= 0);
            end += posShift;
            if (firstEscaped >= 0) {
                firstEscaped += posShift;
            }
            if (!filled) break;
        }
        int start = this.bufferPos;
        this.bufferPos = end;
        this.eol = true;
        int len = end - start;
        if (len == 0) {
            return "";
        }
        if (firstEscaped >= 0) {
            return Tiny2Util.unescape(String.valueOf(this.buffer, start, len));
        }
        return String.valueOf(this.buffer, start, len);
    }

    public int nextIntCol() throws IOException {
        String str = this.nextCol(false);
        try {
            return str != null ? Integer.parseInt(str) : -1;
        }
        catch (NumberFormatException e) {
            throw new IOException("invalid number in line " + this.lineNumber + ": " + str);
        }
    }

    public boolean nextLine(int indent) throws IOException {
        while (true) {
            if (this.bufferPos < this.bufferLimit) {
                char c = this.buffer[this.bufferPos];
                if (c == '\n') {
                    if (indent == 0) {
                        if (!this.fillBuffer(2)) break;
                        c = this.buffer[this.bufferPos + 1];
                        if (c == '\n' || c == '\r') {
                            ++this.bufferPos;
                            ++this.lineNumber;
                            continue;
                        }
                    }
                    if (!this.fillBuffer(indent + 1)) {
                        return false;
                    }
                    for (int i = 1; i <= indent; ++i) {
                        if (this.buffer[this.bufferPos + i] == '\t') continue;
                        return false;
                    }
                    this.bufferPos += indent + 1;
                    ++this.lineNumber;
                    this.eol = false;
                    return true;
                }
                ++this.bufferPos;
                continue;
            }
            if (!this.fillBuffer(1)) break;
        }
        return false;
    }

    public boolean hasExtraIndents() throws IOException {
        return this.fillBuffer(1) && this.buffer[this.bufferPos] == '\t';
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isAtEof() {
        return this.eof;
    }

    public void mark() {
        if (this.bufferPos > 0) {
            int available = this.bufferLimit - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, this.buffer, 0, available);
            this.bufferPos = 0;
            this.bufferLimit = available;
            this.markedLineNumber = this.lineNumber;
            this.markedEol = this.eol;
            this.markedEof = this.eof;
        }
        this.mark = this.bufferPos;
    }

    public void reset() {
        if (this.mark < 0) {
            throw new IllegalStateException("not marked");
        }
        this.bufferPos = this.mark;
        this.lineNumber = this.markedLineNumber;
        this.eol = this.markedEol;
        this.eof = this.markedEof;
    }

    private boolean fillBuffer(int count) throws IOException {
        int available = this.bufferLimit - this.bufferPos;
        int req = count - available;
        if (req <= 0) {
            return true;
        }
        if (this.bufferPos + count > this.buffer.length) {
            if (this.mark >= 0) {
                this.buffer = Arrays.copyOf(this.buffer, Math.max(this.bufferPos + count, this.buffer.length * 2));
            } else {
                if (count > this.buffer.length) {
                    char[] newBuffer = new char[Math.max(count, this.buffer.length * 2)];
                    System.arraycopy(this.buffer, this.bufferPos, newBuffer, 0, available);
                    this.buffer = newBuffer;
                } else {
                    System.arraycopy(this.buffer, this.bufferPos, this.buffer, 0, available);
                }
                this.bufferPos = 0;
                this.bufferLimit = available;
            }
        }
        int reqLimit = this.bufferLimit + req;
        do {
            int read;
            if ((read = this.reader.read(this.buffer, this.bufferLimit, this.buffer.length - this.bufferLimit)) < 0) {
                this.eol = true;
                this.eof = true;
                return false;
            }
            this.bufferLimit += read;
        } while (this.bufferLimit < reqLimit);
        return true;
    }
}

