/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.gridfs.codecs;

import io.github.insideranh.stellarprotect.libs.bson.BsonDateTime;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocumentReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocumentWrapper;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt64;
import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.gridfs.model.GridFSFile;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Date;

public final class GridFSFileCodec
implements Codec<GridFSFile> {
    private final Codec<Document> documentCodec;
    private final Codec<BsonDocument> bsonDocumentCodec;

    public GridFSFileCodec(CodecRegistry registry) {
        this.documentCodec = Assertions.notNull("DocumentCodec", Assertions.notNull("registry", registry).get(Document.class));
        this.bsonDocumentCodec = Assertions.notNull("BsonDocumentCodec", registry.get(BsonDocument.class));
    }

    @Override
    public GridFSFile decode(BsonReader reader, DecoderContext decoderContext) {
        BsonDocument bsonDocument = (BsonDocument)this.bsonDocumentCodec.decode(reader, decoderContext);
        BsonValue id = bsonDocument.get("_id");
        String filename = bsonDocument.get("filename", new BsonString("")).asString().getValue();
        long length = bsonDocument.getNumber("length").longValue();
        int chunkSize = bsonDocument.getNumber("chunkSize").intValue();
        Date uploadDate = new Date(bsonDocument.getDateTime("uploadDate").getValue());
        BsonDocument metadataBsonDocument = bsonDocument.getDocument("metadata", new BsonDocument());
        Document optionalMetadata = this.asDocumentOrNull(metadataBsonDocument);
        return new GridFSFile(id, filename, length, chunkSize, uploadDate, optionalMetadata);
    }

    @Override
    public void encode(BsonWriter writer, GridFSFile value, EncoderContext encoderContext) {
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("_id", value.getId());
        bsonDocument.put("filename", new BsonString(value.getFilename()));
        bsonDocument.put("length", new BsonInt64(value.getLength()));
        bsonDocument.put("chunkSize", new BsonInt32(value.getChunkSize()));
        bsonDocument.put("uploadDate", new BsonDateTime(value.getUploadDate().getTime()));
        Document metadata = value.getMetadata();
        if (metadata != null) {
            bsonDocument.put("metadata", new BsonDocumentWrapper<Document>(metadata, this.documentCodec));
        }
        this.bsonDocumentCodec.encode(writer, bsonDocument, encoderContext);
    }

    @Override
    public Class<GridFSFile> getEncoderClass() {
        return GridFSFile.class;
    }

    @Nullable
    private Document asDocumentOrNull(BsonDocument bsonDocument) {
        if (bsonDocument.isEmpty()) {
            return null;
        }
        BsonDocumentReader reader = new BsonDocumentReader(bsonDocument);
        return (Document)this.documentCodec.decode(reader, DecoderContext.builder().build());
    }
}

