/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoDriverInformation;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.SocketSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Cluster;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DefaultClusterFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalConnectionPoolSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactoryFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.event.EventListenerHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;

public final class Clusters {
    private Clusters() {
    }

    public static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactoryFactory streamFactoryFactory) {
        Assertions.assertNotNull(streamFactoryFactory);
        Assertions.assertNotNull(settings);
        StreamFactory streamFactory = Clusters.getStreamFactory(streamFactoryFactory, settings, false);
        StreamFactory heartbeatStreamFactory = Clusters.getStreamFactory(streamFactoryFactory, settings, true);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), InternalConnectionPoolSettings.builder().build(), TimeoutSettings.create(settings), streamFactory, TimeoutSettings.createHeartbeatSettings(settings), heartbeatStreamFactory, settings.getCredential(), settings.getLoggerSettings(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList(), settings.getServerApi(), settings.getDnsClient());
    }

    private static StreamFactory getStreamFactory(StreamFactoryFactory streamFactoryFactory, MongoClientSettings settings, boolean isHeartbeat) {
        SocketSettings socketSettings = isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings();
        return streamFactoryFactory.create(socketSettings, settings.getSslSettings());
    }
}

