/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDateTime;
import io.github.insideranh.stellarprotect.libs.bson.BsonDecimal128;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonDouble;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt64;
import io.github.insideranh.stellarprotect.libs.bson.BsonNull;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.bson.types.Decimal128;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Beta;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Reason;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlArray;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlBoolean;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlDate;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlEntry;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlExpression;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlInteger;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlMap;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlNumber;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlString;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.mql.MqlValue;
import java.time.Instant;
import java.util.ArrayList;

@Beta(value={Reason.CLIENT})
public final class MqlValues {
    private MqlValues() {
    }

    public static MqlBoolean of(boolean of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonBoolean(of)));
    }

    public static MqlArray<MqlBoolean> ofBooleanArray(boolean ... array) {
        Assertions.notNull("array", array);
        BsonArray bsonArray = new BsonArray();
        for (boolean b : array) {
            bsonArray.add(new BsonBoolean(b));
        }
        return new MqlExpression<MqlBoolean>(cr -> new MqlExpression.AstPlaceholder(bsonArray));
    }

    public static MqlInteger of(int of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonInt32(of)));
    }

    public static MqlArray<MqlInteger> ofIntegerArray(int ... array) {
        Assertions.notNull("array", array);
        BsonArray bsonArray = new BsonArray();
        for (int i : array) {
            bsonArray.add(new BsonInt32(i));
        }
        return new MqlExpression<MqlInteger>(cr -> new MqlExpression.AstPlaceholder(bsonArray));
    }

    public static MqlInteger of(long of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonInt64(of)));
    }

    public static MqlArray<MqlInteger> ofIntegerArray(long ... array) {
        Assertions.notNull("array", array);
        BsonArray bsonArray = new BsonArray();
        for (long i : array) {
            bsonArray.add(new BsonInt64(i));
        }
        return new MqlExpression<MqlInteger>(cr -> new MqlExpression.AstPlaceholder(bsonArray));
    }

    public static MqlNumber of(double of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDouble(of)));
    }

    public static MqlArray<MqlNumber> ofNumberArray(double ... array) {
        Assertions.notNull("array", array);
        BsonArray bsonArray = new BsonArray();
        for (double n : array) {
            bsonArray.add(new BsonDouble(n));
        }
        return new MqlExpression<MqlNumber>(cr -> new MqlExpression.AstPlaceholder(bsonArray));
    }

    public static MqlNumber of(Decimal128 of) {
        Assertions.notNull("Decimal128", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDecimal128(of)));
    }

    public static MqlArray<MqlNumber> ofNumberArray(Decimal128 ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonDecimal128> result = new ArrayList<BsonDecimal128>();
        for (Decimal128 e : array) {
            Assertions.notNull("elements of array", e);
            result.add(new BsonDecimal128(e));
        }
        return new MqlExpression<MqlNumber>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(result)));
    }

    public static MqlDate of(Instant of) {
        Assertions.notNull("Instant", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDateTime(of.toEpochMilli())));
    }

    public static MqlArray<MqlDate> ofDateArray(Instant ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonDateTime> result = new ArrayList<BsonDateTime>();
        for (Instant e : array) {
            Assertions.notNull("elements of array", e);
            result.add(new BsonDateTime(e.toEpochMilli()));
        }
        return new MqlExpression<MqlDate>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(result)));
    }

    public static MqlString of(String of) {
        Assertions.notNull("String", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(MqlValues.wrapString(of)));
    }

    public static MqlArray<MqlString> ofStringArray(String ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonValue> result = new ArrayList<BsonValue>();
        for (String e : array) {
            Assertions.notNull("elements of array", e);
            result.add(MqlValues.wrapString(e));
        }
        return new MqlExpression<MqlString>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(result)));
    }

    private static BsonValue wrapString(String s) {
        BsonString bson = new BsonString(s);
        if (s.contains("$")) {
            return new BsonDocument("$literal", bson);
        }
        return bson;
    }

    public static MqlDocument current() {
        return (MqlDocument)new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonString("$$CURRENT"))).assertImplementsAllExpressions();
    }

    public static <R extends MqlValue> MqlMap<R> currentAsMap() {
        return (MqlMap)new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonString("$$CURRENT"))).assertImplementsAllExpressions();
    }

    @SafeVarargs
    public static <T extends MqlValue> MqlArray<T> ofArray(T ... array) {
        Assertions.notNull("array", array);
        return new MqlExpression(cr -> {
            BsonArray bsonArray = new BsonArray();
            for (MqlValue v : array) {
                Assertions.notNull("elements of array", v);
                bsonArray.add(((MqlExpression)v).toBsonValue((CodecRegistry)cr));
            }
            return new MqlExpression.AstPlaceholder(bsonArray);
        });
    }

    public static <T extends MqlValue> MqlEntry<T> ofEntry(MqlString k, T v) {
        Assertions.notNull("k", k);
        Assertions.notNull("v", v);
        return new MqlExpression(cr -> {
            BsonDocument document = new BsonDocument();
            document.put("k", MqlExpression.toBsonValue(cr, k));
            document.put("v", MqlExpression.toBsonValue(cr, v));
            return new MqlExpression.AstPlaceholder(document);
        });
    }

    public static <T extends MqlValue> MqlMap<T> ofMap() {
        return MqlValues.ofMap(new BsonDocument());
    }

    public static <T extends MqlValue> MqlMap<T> ofMap(Bson map) {
        Assertions.notNull("map", map);
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonDocument("$literal", map.toBsonDocument(BsonDocument.class, (CodecRegistry)cr))));
    }

    public static MqlDocument of(Bson document) {
        Assertions.notNull("document", document);
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonDocument("$literal", document.toBsonDocument(BsonDocument.class, (CodecRegistry)cr))));
    }

    public static MqlValue ofNull() {
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonNull())).assertImplementsAllExpressions();
    }

    static MqlNumber numberToMqlNumber(Number number) {
        Assertions.notNull("number", number);
        if (number instanceof Integer) {
            return MqlValues.of((Integer)number);
        }
        if (number instanceof Long) {
            return MqlValues.of((Long)number);
        }
        if (number instanceof Double) {
            return MqlValues.of((Double)number);
        }
        if (number instanceof Decimal128) {
            return MqlValues.of((Decimal128)number);
        }
        throw new IllegalArgumentException("Number must be one of: Integer, Long, Double, Decimal128");
    }
}

