/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonNumber;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCommandException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoOperationTimeoutException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoSocketException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ExceptionUtils {
    public static boolean isMongoSocketException(Throwable e) {
        return e instanceof MongoSocketException;
    }

    public static boolean isOperationTimeoutFromSocketException(Throwable e) {
        return e instanceof MongoOperationTimeoutException && e.getCause() instanceof MongoSocketException;
    }

    private ExceptionUtils() {
    }

    public static final class MongoCommandExceptionUtils {
        public static int extractErrorCode(BsonDocument response) {
            return MongoCommandExceptionUtils.extractErrorCodeAsBson(response).intValue();
        }

        public static String extractErrorCodeName(BsonDocument response) {
            return MongoCommandExceptionUtils.extractErrorCodeNameAsBson(response).getValue();
        }

        public static BsonArray extractErrorLabelsAsBson(BsonDocument response) {
            return response.getArray("errorLabels", new BsonArray());
        }

        private static BsonNumber extractErrorCodeAsBson(BsonDocument response) {
            return response.getNumber("code", new BsonInt32(-1));
        }

        private static BsonString extractErrorCodeNameAsBson(BsonDocument response) {
            return response.getString("codeName", new BsonString(""));
        }

        public static MongoCommandException redacted(MongoCommandException original) {
            BsonDocument originalResponse = original.getResponse();
            BsonDocument redactedResponse = new BsonDocument();
            for (SecurityInsensitiveResponseField field : SecurityInsensitiveResponseField.values()) {
                redactedResponse.append(field.fieldName(), field.fieldValue(originalResponse));
            }
            MongoCommandException result = new MongoCommandException(redactedResponse, original.getServerAddress());
            result.setStackTrace(original.getStackTrace());
            return result;
        }

        private MongoCommandExceptionUtils() {
        }

        public static enum SecurityInsensitiveResponseField {
            CODE("code", x$0 -> MongoCommandExceptionUtils.access$100(x$0)),
            CODE_NAME("codeName", x$0 -> MongoCommandExceptionUtils.access$000(x$0)),
            ERROR_LABELS("errorLabels", MongoCommandExceptionUtils::extractErrorLabelsAsBson);

            private final String fieldName;
            private final Function<BsonDocument, BsonValue> fieldValueExtractor;

            private SecurityInsensitiveResponseField(String fieldName, Function<BsonDocument, BsonValue> fieldValueExtractor) {
                this.fieldName = fieldName;
                this.fieldValueExtractor = fieldValueExtractor;
            }

            String fieldName() {
                return this.fieldName;
            }

            BsonValue fieldValue(BsonDocument response) {
                return this.fieldValueExtractor.apply(response);
            }

            public static Set<String> fieldNames() {
                return Stream.of(SecurityInsensitiveResponseField.values()).map(SecurityInsensitiveResponseField::fieldName).collect(Collectors.toSet());
            }
        }
    }
}

