/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.ByteBuf;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ReplyHeader;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ReplyMessage;
import java.io.Closeable;

public class ResponseBuffers
implements Closeable {
    private final ReplyHeader replyHeader;
    private final ByteBuf bodyByteBuffer;
    private final int bodyByteBufferStartPosition;
    private volatile boolean isClosed;

    ResponseBuffers(ReplyHeader replyHeader, ByteBuf bodyByteBuffer) {
        this.replyHeader = replyHeader;
        this.bodyByteBuffer = bodyByteBuffer;
        this.bodyByteBufferStartPosition = bodyByteBuffer == null ? 0 : bodyByteBuffer.position();
    }

    public ReplyHeader getReplyHeader() {
        return this.replyHeader;
    }

    <T extends BsonDocument> T getResponseDocument(int messageId, Decoder<T> decoder) {
        ReplyMessage<T> replyMessage = new ReplyMessage<T>(this, decoder, messageId);
        this.reset();
        return (T)((BsonDocument)replyMessage.getDocument());
    }

    public ByteBuf getBodyByteBuffer() {
        return this.bodyByteBuffer;
    }

    public void reset() {
        this.bodyByteBuffer.position(this.bodyByteBufferStartPosition);
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            if (this.bodyByteBuffer != null) {
                this.bodyByteBuffer.release();
            }
            this.isClosed = true;
        }
    }
}

