/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.mongodb.AuthenticationMechanism;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCommandException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoSecurityException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerApi;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterConnectionMode;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Authenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.CommandHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.SpeculativeAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Logger;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Loggers;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;

class X509Authenticator
extends Authenticator
implements SpeculativeAuthenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");
    private BsonDocument speculativeAuthenticateResponse;

    X509Authenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription, OperationContext operationContext) {
        if (this.speculativeAuthenticateResponse != null) {
            return;
        }
        try {
            BsonDocument authCommand = this.getAuthCommand(this.getMongoCredential().getUserName());
            CommandHelper.executeCommand(this.getMongoCredential().getSource(), authCommand, this.getClusterConnectionMode(), this.getServerApi(), connection, operationContext);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, OperationContext operationContext, SingleResultCallback<Void> callback) {
        if (this.speculativeAuthenticateResponse != null) {
            callback.onResult(null, null);
        } else {
            SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
            try {
                CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), this.getAuthCommand(this.getMongoCredential().getUserName()), this.getClusterConnectionMode(), this.getServerApi(), connection, operationContext, (nonceResult, t) -> {
                    if (t != null) {
                        errHandlingCallback.onResult(null, this.translateThrowable(t));
                    } else {
                        errHandlingCallback.onResult(null, null);
                    }
                });
            }
            catch (Throwable t2) {
                errHandlingCallback.onResult(null, t2);
            }
        }
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection connection) {
        return this.getAuthCommand(this.getMongoCredential().getUserName()).append("db", new BsonString("$external"));
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument response) {
        this.speculativeAuthenticateResponse = response;
    }

    @Override
    public BsonDocument getSpeculativeAuthenticateResponse() {
        return this.speculativeAuthenticateResponse;
    }

    private BsonDocument getAuthCommand(@Nullable String userName) {
        BsonDocument cmd = new BsonDocument();
        cmd.put("authenticate", new BsonInt32(1));
        if (userName != null) {
            cmd.put("user", new BsonString(userName));
        }
        cmd.put("mechanism", new BsonString(AuthenticationMechanism.MONGODB_X509.getMechanismName()));
        return cmd;
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", t);
        }
        return t;
    }
}

