/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonDocumentCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.cursor.TimeoutMode;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Collation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.AggregationLevel;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteConcernHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.List;

public class AggregateToCollectionOperation
implements AsyncReadOperation<Void>,
ReadOperation<Void> {
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;

    public AggregateToCollectionOperation(MongoNamespace namespace, List<BsonDocument> pipeline, ReadConcern readConcern, WriteConcern writeConcern) {
        this(namespace, pipeline, readConcern, writeConcern, AggregationLevel.COLLECTION);
    }

    public AggregateToCollectionOperation(MongoNamespace namespace, List<BsonDocument> pipeline, @Nullable ReadConcern readConcern, @Nullable WriteConcern writeConcern, AggregationLevel aggregationLevel) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.writeConcern = writeConcern;
        this.readConcern = readConcern;
        this.aggregationLevel = Assertions.notNull("aggregationLevel", aggregationLevel);
        Assertions.isTrueArgument("pipeline is not empty", !pipeline.isEmpty());
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregateToCollectionOperation allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public AggregateToCollectionOperation bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public AggregateToCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public AggregateToCollectionOperation let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    public AggregateToCollectionOperation comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public AggregateToCollectionOperation hint(@Nullable BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public AggregateToCollectionOperation timeoutMode(@Nullable TimeoutMode timeoutMode) {
        Assertions.isTrueArgument("timeoutMode cannot be ITERATION.", timeoutMode == null || timeoutMode.equals((Object)TimeoutMode.CURSOR_LIFETIME));
        return this;
    }

    @Override
    public Void execute(ReadBinding binding) {
        return SyncOperationHelper.executeRetryableRead(binding, () -> binding.getReadConnectionSource(13, ReadPreference.primary()), this.namespace.getDatabaseName(), this.getCommandCreator(), new BsonDocumentCodec(), (result, source, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), binding.getOperationContext().getTimeoutContext());
            return null;
        }, false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, connectionSourceCallback -> binding.getReadConnectionSource(13, ReadPreference.primary(), connectionSourceCallback), this.namespace.getDatabaseName(), this.getCommandCreator(), new BsonDocumentCodec(), (result, source, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), binding.getOperationContext().getTimeoutContext());
            return null;
        }, false, callback);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonValue aggregationTarget = this.aggregationLevel == AggregationLevel.DATABASE ? new BsonInt32(1) : new BsonString(this.namespace.getCollectionName());
            BsonDocument commandDocument = new BsonDocument("aggregate", aggregationTarget);
            commandDocument.put("pipeline", new BsonArray(this.pipeline));
            if (this.allowDiskUse != null) {
                commandDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
            }
            if (this.bypassDocumentValidation != null) {
                commandDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
            }
            commandDocument.put("cursor", new BsonDocument());
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
            if (this.readConcern != null && !this.readConcern.isServerDefault()) {
                commandDocument.put("readConcern", this.readConcern.asDocument());
            }
            if (this.collation != null) {
                commandDocument.put("collation", this.collation.asDocument());
            }
            if (this.comment != null) {
                commandDocument.put("comment", this.comment);
            }
            if (this.hint != null) {
                commandDocument.put("hint", this.hint);
            }
            if (this.variables != null) {
                commandDocument.put("let", this.variables);
            }
            return commandDocument;
        };
    }
}

