/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCommandException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoConnectionPoolClearedException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNodeIsRecoveringException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNotPrimaryException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoSecurityException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoServerException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoSocketException;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.function.RetryState;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.OperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.retry.AttachmentKeys;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.session.SessionContext;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

final class CommandOperationHelper {
    private static final List<Integer> RETRYABLE_ERROR_CODES = Arrays.asList(6, 7, 89, 91, 134, 189, 262, 9001, 13436, 13435, 11602, 11600, 10107);
    static final String RETRYABLE_WRITE_ERROR_LABEL = "RetryableWriteError";
    private static final String NO_WRITES_PERFORMED_ERROR_LABEL = "NoWritesPerformed";

    static WriteConcern validateAndGetEffectiveWriteConcern(WriteConcern writeConcernSetting, SessionContext sessionContext) throws MongoClientException {
        WriteConcern effectiveWriteConcern;
        boolean activeTransaction = sessionContext.hasActiveTransaction();
        WriteConcern writeConcern = effectiveWriteConcern = activeTransaction ? WriteConcern.ACKNOWLEDGED : writeConcernSetting;
        if (sessionContext.hasSession() && !sessionContext.isImplicitSession() && !activeTransaction && !effectiveWriteConcern.isAcknowledged()) {
            throw new MongoClientException("Unacknowledged writes are not supported when using an explicit session");
        }
        return effectiveWriteConcern;
    }

    static Optional<WriteConcern> commandWriteConcern(WriteConcern effectiveWriteConcern, SessionContext sessionContext) {
        return effectiveWriteConcern.isServerDefault() || sessionContext.hasActiveTransaction() ? Optional.empty() : Optional.of(effectiveWriteConcern);
    }

    static BinaryOperator<Throwable> onRetryableReadAttemptFailure(OperationContext operationContext) {
        return (previouslyChosenException, mostRecentAttemptException) -> {
            operationContext.getServerDeprioritization().onAttemptFailure((Throwable)mostRecentAttemptException);
            return CommandOperationHelper.chooseRetryableReadException(previouslyChosenException, mostRecentAttemptException);
        };
    }

    private static Throwable chooseRetryableReadException(@Nullable Throwable previouslyChosenException, Throwable mostRecentAttemptException) {
        Assertions.assertFalse(mostRecentAttemptException instanceof OperationHelper.ResourceSupplierInternalException);
        if (previouslyChosenException == null || mostRecentAttemptException instanceof MongoSocketException || mostRecentAttemptException instanceof MongoServerException) {
            return mostRecentAttemptException;
        }
        return previouslyChosenException;
    }

    static BinaryOperator<Throwable> onRetryableWriteAttemptFailure(OperationContext operationContext) {
        return (previouslyChosenException, mostRecentAttemptException) -> {
            operationContext.getServerDeprioritization().onAttemptFailure((Throwable)mostRecentAttemptException);
            return CommandOperationHelper.chooseRetryableWriteException(previouslyChosenException, mostRecentAttemptException);
        };
    }

    private static Throwable chooseRetryableWriteException(@Nullable Throwable previouslyChosenException, Throwable mostRecentAttemptException) {
        if (previouslyChosenException == null) {
            if (mostRecentAttemptException instanceof OperationHelper.ResourceSupplierInternalException) {
                return mostRecentAttemptException.getCause();
            }
            return mostRecentAttemptException;
        }
        if (mostRecentAttemptException instanceof OperationHelper.ResourceSupplierInternalException || mostRecentAttemptException instanceof MongoException && ((MongoException)mostRecentAttemptException).hasErrorLabel(NO_WRITES_PERFORMED_ERROR_LABEL)) {
            return previouslyChosenException;
        }
        return mostRecentAttemptException;
    }

    static RetryState initialRetryState(boolean retry, TimeoutContext timeoutContext) {
        if (retry) {
            return RetryState.withRetryableState(1, timeoutContext);
        }
        return RetryState.withNonRetryableState();
    }

    static boolean isRetryableException(Throwable t) {
        if (!(t instanceof MongoException)) {
            return false;
        }
        if (t instanceof MongoSocketException || t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException || t instanceof MongoConnectionPoolClearedException) {
            return true;
        }
        return RETRYABLE_ERROR_CODES.contains(((MongoException)t).getCode());
    }

    static void rethrowIfNotNamespaceError(MongoCommandException e) {
        CommandOperationHelper.rethrowIfNotNamespaceError(e, null);
    }

    @Nullable
    static <T> T rethrowIfNotNamespaceError(MongoCommandException e, @Nullable T defaultValue) {
        if (!CommandOperationHelper.isNamespaceError(e)) {
            throw e;
        }
        return defaultValue;
    }

    static boolean isNamespaceError(Throwable t) {
        if (t instanceof MongoCommandException) {
            MongoCommandException e = (MongoCommandException)t;
            return e.getErrorMessage().contains("ns not found") || e.getErrorCode() == 26;
        }
        return false;
    }

    static boolean shouldAttemptToRetryRead(RetryState retryState, Throwable attemptFailure) {
        boolean decision;
        Assertions.assertFalse(attemptFailure instanceof OperationHelper.ResourceSupplierInternalException);
        boolean bl = decision = CommandOperationHelper.isRetryableException(attemptFailure) || attemptFailure instanceof MongoSecurityException && attemptFailure.getCause() != null && CommandOperationHelper.isRetryableException(attemptFailure.getCause());
        if (!decision) {
            CommandOperationHelper.logUnableToRetry(retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElse(null), attemptFailure);
        }
        return decision;
    }

    static boolean loggingShouldAttemptToRetryWriteAndAddRetryableLabel(RetryState retryState, Throwable attemptFailure) {
        boolean decision;
        Throwable attemptFailureNotToBeRetried = CommandOperationHelper.getAttemptFailureNotToRetryOrAddRetryableLabel(retryState, attemptFailure);
        boolean bl = decision = attemptFailureNotToBeRetried == null;
        if (!decision && retryState.attachment(AttachmentKeys.retryableCommandFlag()).orElse(false).booleanValue()) {
            CommandOperationHelper.logUnableToRetry(retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElse(null), Assertions.assertNotNull(attemptFailureNotToBeRetried));
        }
        return decision;
    }

    static boolean shouldAttemptToRetryWriteAndAddRetryableLabel(RetryState retryState, Throwable attemptFailure) {
        return CommandOperationHelper.getAttemptFailureNotToRetryOrAddRetryableLabel(retryState, attemptFailure) != null;
    }

    @Nullable
    private static Throwable getAttemptFailureNotToRetryOrAddRetryableLabel(RetryState retryState, Throwable attemptFailure) {
        Throwable failure = attemptFailure instanceof OperationHelper.ResourceSupplierInternalException ? attemptFailure.getCause() : attemptFailure;
        boolean decision = false;
        MongoException exceptionRetryableRegardlessOfCommand = null;
        if (failure instanceof MongoConnectionPoolClearedException || failure instanceof MongoSecurityException && failure.getCause() != null && CommandOperationHelper.isRetryableException(failure.getCause())) {
            decision = true;
            exceptionRetryableRegardlessOfCommand = (MongoException)failure;
        }
        if (retryState.attachment(AttachmentKeys.retryableCommandFlag()).orElse(false).booleanValue()) {
            if (exceptionRetryableRegardlessOfCommand != null) {
                exceptionRetryableRegardlessOfCommand.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
            } else if (CommandOperationHelper.decideRetryableAndAddRetryableWriteErrorLabel(failure, retryState.attachment(AttachmentKeys.maxWireVersion()).orElse(null))) {
                decision = true;
            }
        }
        return decision ? null : Assertions.assertNotNull(failure);
    }

    static boolean isRetryWritesEnabled(@Nullable BsonDocument command) {
        return command != null && (command.containsKey("txnNumber") || command.getFirstKey().equals("commitTransaction") || command.getFirstKey().equals("abortTransaction"));
    }

    private static boolean decideRetryableAndAddRetryableWriteErrorLabel(Throwable t, @Nullable Integer maxWireVersion) {
        if (!(t instanceof MongoException)) {
            return false;
        }
        MongoException exception = (MongoException)t;
        if (maxWireVersion != null) {
            CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
        }
        return exception.hasErrorLabel(RETRYABLE_WRITE_ERROR_LABEL);
    }

    static void addRetryableWriteErrorLabel(MongoException exception, int maxWireVersion) {
        if (maxWireVersion >= 9 && exception instanceof MongoSocketException) {
            exception.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
        } else if (maxWireVersion < 9 && CommandOperationHelper.isRetryableException(exception)) {
            exception.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
        }
    }

    static void logRetryExecute(RetryState retryState, OperationContext operationContext) {
        if (OperationHelper.LOGGER.isDebugEnabled() && !retryState.isFirstAttempt()) {
            String commandDescription = retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).map(Supplier::get).orElse(null);
            Throwable exception = retryState.exception().orElseThrow(Assertions::fail);
            int oneBasedAttempt = retryState.attempt() + 1;
            long operationId = operationContext.getId();
            OperationHelper.LOGGER.debug(commandDescription == null ? String.format("Retrying the operation with operation ID %s due to the error \"%s\". Attempt number: #%d", operationId, exception, oneBasedAttempt) : String.format("Retrying the operation '%s' with operation ID %s due to the error \"%s\". Attempt number: #%d", commandDescription, operationId, exception, oneBasedAttempt));
        }
    }

    private static void logUnableToRetry(@Nullable Supplier<String> commandDescriptionSupplier, Throwable originalError) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            String commandDescription = commandDescriptionSupplier == null ? null : commandDescriptionSupplier.get();
            OperationHelper.LOGGER.debug(commandDescription == null ? String.format("Unable to retry an operation due to the error \"%s\"", originalError) : String.format("Unable to retry the operation %s due to the error \"%s\"", commandDescription, originalError));
        }
    }

    static MongoException transformWriteException(MongoException exception) {
        if (exception.getCode() == 20 && exception.getMessage().contains("Transaction numbers")) {
            MongoClientException clientException = new MongoClientException("This MongoDB deployment does not support retryable writes. Please add retryWrites=false to your connection string.", exception);
            for (String errorLabel : exception.getErrorLabels()) {
                clientException.addLabel(errorLabel);
            }
            return clientException;
        }
        return exception;
    }

    private CommandOperationHelper() {
    }

    static interface CommandCreator {
        public BsonDocument create(OperationContext var1, ServerDescription var2, ConnectionDescription var3);
    }
}

