/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoWriteConcernException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcernResult;
import io.github.insideranh.stellarprotect.libs.mongodb.bulk.WriteConcernError;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ProtocolHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class WriteConcernHelper {
    public static void appendWriteConcernToCommand(WriteConcern writeConcern, BsonDocument commandDocument) {
        if (writeConcern != null && !writeConcern.isServerDefault()) {
            commandDocument.put("writeConcern", writeConcern.asDocument());
        }
    }

    @Nullable
    public static WriteConcern cloneWithoutTimeout(@Nullable WriteConcern writeConcern) {
        if (writeConcern == null || writeConcern.getWTimeout(TimeUnit.MILLISECONDS) == null) {
            return writeConcern;
        }
        Object w = writeConcern.getWObject();
        WriteConcern mapped = w == null ? WriteConcern.ACKNOWLEDGED : (w instanceof Integer ? new WriteConcern((Integer)w) : new WriteConcern((String)w));
        return mapped.withJournal(writeConcern.getJournal());
    }

    public static void throwOnWriteConcernError(BsonDocument result, ServerAddress serverAddress, int maxWireVersion, TimeoutContext timeoutContext) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            MongoException exception = ProtocolHelper.createSpecialException(result, serverAddress, "errmsg", timeoutContext);
            if (exception == null) {
                exception = WriteConcernHelper.createWriteConcernException(result, serverAddress);
            }
            CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
            throw exception;
        }
    }

    public static boolean hasWriteConcernError(BsonDocument result) {
        return result.containsKey("writeConcernError");
    }

    public static MongoWriteConcernException createWriteConcernException(BsonDocument result, ServerAddress serverAddress) {
        return new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument("writeConcernError")), WriteConcernResult.acknowledged(0, false, null), serverAddress, result.getArray("errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).collect(Collectors.toSet()));
    }

    public static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber("code").intValue(), writeConcernErrorDocument.getString("codeName", new BsonString("")).getValue(), writeConcernErrorDocument.getString("errmsg").getValue(), writeConcernErrorDocument.getDocument("errInfo", new BsonDocument()));
    }

    private WriteConcernHelper() {
    }
}

