/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.listeners;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.blocks.adjacents.AdjacentTracker;
import io.github.insideranh.stellarprotect.blocks.adjacents.AdjacentType;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockStateLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerItemLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerTameEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemReference;
import io.github.insideranh.stellarprotect.trackers.BlockTracker;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BlockListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        this.processBlockBreak(block, player, -2L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.processBlockPlace(event.getBlock(), null, PlayerUtils.getPlayerOrEntityId("=fire"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBurn(BlockBurnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.processBlockBreak(event.getBlock(), null, PlayerUtils.getPlayerOrEntityId("=fire"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        this.processBlockPlace(block, player, -2L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockSpread(BlockSpreadEvent event) {
        long playerId;
        if (event.isCancelled()) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        BlockState newState = event.getNewState();
        Material newMaterial = newState.getType();
        if (BlockTracker.isChorusState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=chorus");
        } else if (BlockTracker.isAmethystState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=amethyst");
        } else if (BlockTracker.isBambooState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=bamboo");
        } else if (BlockTracker.isSculkState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=sculk");
        } else if (BlockTracker.isVineState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=vine");
        } else {
            return;
        }
        this.processBlockStatePlace(event.getBlock().getLocation(), blockState, newState, playerId);
    }

    void processBlockBreak(Block block, @Nullable Player player, long defaultId) {
        List<Block> affectedBlocks;
        Material material = block.getType();
        if (block.getType().equals((Object)Material.AIR) || ActionType.BLOCK_BREAK.shouldSkipLog(block.getWorld().getName(), material.name())) {
            return;
        }
        long playerId = this.getPlayerId(player, defaultId);
        if (this.plugin.getNexoHook() != null && this.plugin.getNexoHook().isNexoBlock(block)) {
            return;
        }
        if (this.plugin.getItemsAdderHook() != null && this.plugin.getItemsAdderHook().isItemsAdderBlock(block)) {
            return;
        }
        if (AdjacentType.isUp(material)) {
            affectedBlocks = AdjacentTracker.getAffectedBlocksAbove(block);
            for (Block affectedBlock : affectedBlocks) {
                LoggerCache.addLog(new PlayerBlockLogEntry(playerId, affectedBlock, ActionType.BLOCK_BREAK));
            }
        }
        if (AdjacentType.isSide(material)) {
            affectedBlocks = AdjacentTracker.getAffectedBlocksSide(block);
            for (Block affectedBlock : affectedBlocks) {
                LoggerCache.addLog(new PlayerBlockLogEntry(playerId, affectedBlock, ActionType.BLOCK_BREAK));
            }
        }
        LoggerCache.addLog(new PlayerBlockLogEntry(playerId, block, ActionType.BLOCK_BREAK));
    }

    void processBlockStatePlace(Location location, BlockState blockState, BlockState newState, long playerId) {
        if (newState.getType().equals((Object)Material.AIR) || ActionType.BLOCK_SPREAD.shouldSkipLog(newState.getWorld().getName(), newState.getType().name())) {
            return;
        }
        LoggerCache.addLog(new PlayerBlockStateLogEntry(playerId, location, blockState, newState, ActionType.BLOCK_SPREAD));
    }

    void processBlockPlace(Block block, @Nullable Player player, long defaultId) {
        if (block.getType().equals((Object)Material.AIR) || ActionType.BLOCK_PLACE.shouldSkipLog(block.getWorld().getName(), block.getType().name())) {
            return;
        }
        long playerId = this.getPlayerId(player, defaultId);
        if (this.plugin.getNexoHook() != null && this.plugin.getNexoHook().isNexoListener(block, this.plugin.getProtectNMS().getItemInHand(player))) {
            return;
        }
        if (this.plugin.getItemsAdderHook() != null && this.plugin.getItemsAdderHook().isItemsAdderListener(block, this.plugin.getProtectNMS().getItemInHand(player))) {
            return;
        }
        LoggerCache.addLog(new PlayerBlockLogEntry(playerId, block, ActionType.BLOCK_PLACE));
    }

    long getPlayerId(@Nullable Player player, long defaultId) {
        if (player == null) {
            return defaultId;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return defaultId;
        }
        return playerProtect.getPlayerId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLeavesDecay(LeavesDecayEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (ActionType.BLOCK_BREAK.shouldSkipLog(block.getWorld().getName(), "=decay")) {
            return;
        }
        LoggerCache.addLog(new PlayerBlockLogEntry(PlayerUtils.getEntityByDirectId("=decay"), block, ActionType.BLOCK_BREAK));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFurnaceExtract(FurnaceExtractEvent event) {
        Block block = event.getBlock();
        if (ActionType.FURNACE_EXTRACT.shouldSkipLog(block.getWorld().getName(), event.getItemType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(event.getPlayer());
        if (playerProtect == null) {
            return;
        }
        ItemReference itemReference = this.plugin.getItemsManager().getItemReference(new ItemStack(event.getItemType(), event.getItemAmount()));
        LoggerCache.addLog(new PlayerItemLogEntry(playerProtect.getPlayerId(), itemReference, block.getLocation(), ActionType.FURNACE_EXTRACT));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTame(EntityTameEvent event) {
        if (!(event.getOwner() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getOwner();
        if (!(event.getEntity() instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)event.getEntity();
        if (ActionType.TAME.shouldSkipLog(animal.getWorld().getName(), animal.getType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        LoggerCache.addLog(new PlayerTameEntry(playerProtect.getPlayerId(), (Entity)animal));
    }
}

