/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.arguments;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.LocationArg;
import io.github.InsiderAnh.StellarProtect.arguments.PageArg;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.arguments.UsersArg;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.enums.TimesType;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.lang.Nullable;
import io.github.InsiderAnh.StellarProtect.utils.PlayerUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.bukkit.Location;

public class ArgumentsParser {
    private static final Pattern TIME_PATTERN = Pattern.compile("([\\d.]+)(mo|[ywdhms])");

    static int parseDuration(String input) {
        Matcher matcher = TIME_PATTERN.matcher(input.toLowerCase(Locale.ROOT));
        int totalSeconds = 0;
        block0: while (matcher.find()) {
            double value = ArgumentsParser.parseSafeDouble(matcher.group(1));
            String symbol = matcher.group(2);
            for (TimesType unit : TimesType.values()) {
                if (!unit.getSymbol().equals(symbol)) continue;
                totalSeconds += (int)(value * (double)unit.getSeconds());
                continue block0;
            }
        }
        return totalSeconds;
    }

    static double parseSafeDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    static int parseSafeInteger(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static List<ActionType> parseActionTypes(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        ArrayList<ActionType> actionTypes = new ArrayList<ActionType>();
        for (String part : joined.split("\\s+")) {
            if (!part.startsWith("a:") && !part.startsWith("action:")) continue;
            String actionType = part.replaceFirst("^(a:|action:)", "");
            for (String action : actionType.split(",")) {
                actionTypes.add(ActionType.getByName(action));
            }
        }
        return actionTypes;
    }

    @Nullable
    public static LocationArg parseLocation(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        for (String part : joined.split("\\s+")) {
            String locationSegment;
            String[] data;
            if (!part.startsWith("l:") && !part.startsWith("location:") || (data = (locationSegment = part.replaceFirst("^(l:|location:)", "")).split(";")).length != 4) continue;
            return new LocationArg(data[0], Integer.parseInt(data[1]), Integer.parseInt(data[2]), Integer.parseInt(data[3]));
        }
        return null;
    }

    @NonNull
    public static TimeArg parseTime(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        for (String part : joined.split("\\s+")) {
            long timeEnd;
            if (!part.startsWith("t:") && !part.startsWith("time:")) continue;
            String timeSegment = part.replaceFirst("^(t:|time:)", "");
            String[] rangeParts = timeSegment.split("-");
            if (rangeParts.length == 0) {
                return new TimeArg("", "", System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L), System.currentTimeMillis());
            }
            String startString = rangeParts[0];
            String endString = rangeParts.length > 1 ? rangeParts[1] : "";
            long startDurationMs = (long)ArgumentsParser.parseDuration(rangeParts[0]) * 1000L;
            long endDurationMs = rangeParts.length > 1 ? (long)ArgumentsParser.parseDuration(rangeParts[1]) * 1000L : 0L;
            long timeStart = System.currentTimeMillis() - startDurationMs;
            long l = timeEnd = endDurationMs > 0L ? System.currentTimeMillis() - endDurationMs : System.currentTimeMillis();
            if (timeStart > timeEnd) {
                long temp = timeStart;
                timeStart = timeEnd;
                timeEnd = temp;
            }
            return new TimeArg(startString, endString, timeStart, timeEnd);
        }
        return new TimeArg("", "", 0L, System.currentTimeMillis());
    }

    @NonNull
    public static PageArg parsePage(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        for (String part : joined.split("\\s+")) {
            if (!part.startsWith("p:") && !part.startsWith("page:")) continue;
            String timeSegment = part.replaceFirst("^(p:|page:)", "");
            String[] rangeParts = timeSegment.split("-");
            if (rangeParts.length == 0) {
                rangeParts = new String[]{"1", "10"};
            }
            if (rangeParts.length == 1) {
                rangeParts = new String[]{rangeParts[0], "10"};
            }
            int page = ArgumentsParser.parseSafeInteger(rangeParts[0], 1);
            int perPage = ArgumentsParser.parseSafeInteger(rangeParts[1], 10);
            return new PageArg(page, perPage);
        }
        return new PageArg(1, 10);
    }

    @NonNull
    public static CompletableFuture<UsersArg> parseUsers(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "");
        for (String part : joined.split("\\s+")) {
            if (!part.startsWith("u:") && !part.startsWith("users:")) continue;
            String usersSegment = part.replaceFirst("^(u:|users:)", "");
            String[] userNames = usersSegment.split(",");
            return CompletableFuture.supplyAsync(() -> {
                HashSet<Long> userIds = new HashSet<Long>();
                ArrayList<String> notFoundNames = new ArrayList<String>();
                for (String userName : userNames) {
                    if ((userName = userName.trim()).isEmpty()) continue;
                    long userId = PlayerUtils.getPlayerOrEntityId(userName);
                    if (userId != -2L) {
                        userIds.add(userId);
                        continue;
                    }
                    notFoundNames.add(userName);
                }
                List<Long> dbUserIds = StellarProtect.getInstance().getProtectDatabase().getIdsByNames(notFoundNames);
                userIds.addAll(dbUserIds);
                return new UsersArg(userIds);
            });
        }
        return CompletableFuture.completedFuture(new UsersArg(new long[0]));
    }

    @Nullable
    public static RadiusArg parseRadiusOrNull(String[] arguments, @NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        for (String part : joined.split("\\s+")) {
            String radiusSegment;
            if (!part.startsWith("r:") && !part.startsWith("radius:") || (radiusSegment = part.replaceFirst("^(r:|radius:)", "")).isEmpty()) continue;
            try {
                double radius = Double.parseDouble(radiusSegment);
                return new RadiusArg(radius, (double)location.getBlockX() - radius, (double)location.getBlockX() + radius, (double)location.getBlockY() - radius, (double)location.getBlockY() + radius, (double)location.getBlockZ() - radius, (double)location.getBlockZ() + radius);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

