/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.commands.completers;

import com.google.common.base.Joiner;
import io.github.InsiderAnh.StellarProtect.commands.StellarCompleter;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LookupCompleter
extends StellarCompleter {
    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        if (arguments.length == 0) {
            return this.getDefaultSuggestions();
        }
        ArgumentParser parser = new ArgumentParser();
        parser.parseExistingArguments(arguments);
        String currentArg = arguments[arguments.length - 1];
        if (!currentArg.contains(":")) {
            return this.getAvailableArguments(parser);
        }
        String[] parts = currentArg.split(":", 2);
        if (parts.length != 2) {
            return this.getAvailableArguments(parser);
        }
        String prefix = parts[0];
        String value = parts[1];
        ArgumentType currentType = ArgumentType.fromPrefix(prefix);
        if (currentType == null) {
            return this.getAvailableArguments(parser);
        }
        return this.getSuggestionsForArgument(currentType, prefix, value, parser);
    }

    private List<String> getDefaultSuggestions() {
        return Arrays.asList("t:1h", "r:10", "p:1-10", "a:block_break", "u:player");
    }

    private List<String> getAvailableArguments(ArgumentParser parser) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (ArgumentType type : ArgumentType.values()) {
            if ((type == ArgumentType.RADIUS || type == ArgumentType.TIME || type == ArgumentType.PAGE) && parser.isArgumentUsed(type)) continue;
            suggestions.add(type.getShortPrefix() + ":");
        }
        return suggestions;
    }

    private List<String> getSuggestionsForArgument(ArgumentType type, String usedPrefix, String value, ArgumentParser parser) {
        switch (type.ordinal()) {
            case 0: {
                return this.handleActionSuggestions(usedPrefix, value);
            }
            case 1: {
                if (parser.isArgumentUsed(type) && !value.isEmpty()) {
                    return Collections.emptyList();
                }
                return Arrays.asList(usedPrefix + ":1h", usedPrefix + ":1d", usedPrefix + ":1w", usedPrefix + ":1mo");
            }
            case 2: {
                if (parser.isArgumentUsed(type) && !value.isEmpty()) {
                    return Collections.emptyList();
                }
                return Arrays.asList(usedPrefix + ":10", usedPrefix + ":20", usedPrefix + ":30", usedPrefix + ":40", usedPrefix + ":50");
            }
            case 3: {
                if (parser.isArgumentUsed(type) && !value.isEmpty()) {
                    return Collections.emptyList();
                }
                return Arrays.asList(usedPrefix + ":1-10", usedPrefix + ":2-10", usedPrefix + ":1-20");
            }
            case 4: {
                return this.handleUserSuggestions(usedPrefix, value);
            }
        }
        return Collections.emptyList();
    }

    private List<String> handleActionSuggestions(String usedPrefix, String value) {
        String[] existingActions = value.split(",");
        if (value.isEmpty() || existingActions.length == 0) {
            return ActionType.getAllNames(null);
        }
        List<String> suggestions = ActionType.getAllNamesNoPrefix(null);
        LinkedList<String> usedActions = new LinkedList<String>();
        LinkedList<String> completions = new LinkedList<String>();
        String lastAction = existingActions[existingActions.length - 1].trim();
        for (String part : value.split(",")) {
            String partTrimmed = part.trim();
            if (partTrimmed.equals(lastAction) || partTrimmed.isEmpty()) continue;
            suggestions.remove(partTrimmed);
            usedActions.add(partTrimmed);
        }
        for (String action : suggestions) {
            if (!lastAction.isEmpty() && !action.startsWith(lastAction)) continue;
            if (usedActions.isEmpty()) {
                completions.add(usedPrefix + ":" + action);
                continue;
            }
            completions.add(usedPrefix + ":" + Joiner.on((String)",").join(usedActions) + "," + action);
        }
        if (completions.isEmpty()) {
            String prefix = usedActions.isEmpty() ? usedPrefix + ":" + lastAction : usedPrefix + ":" + Joiner.on((String)",").join(usedActions) + "," + lastAction;
            return Collections.singletonList(prefix);
        }
        return completions;
    }

    private List<String> handleUserSuggestions(String usedPrefix, String value) {
        String[] existingUsers = value.split(",");
        if (value.isEmpty() || existingUsers.length == 0) {
            ArrayList<String> suggestions = new ArrayList<String>();
            AtomicInteger count = new AtomicInteger(0);
            for (Player player : Bukkit.getOnlinePlayers()) {
                suggestions.add(usedPrefix + ":" + player.getName());
                count.getAndIncrement();
                if (count.get() < 10) continue;
                break;
            }
            return suggestions;
        }
        LinkedList<String> usedUsers = new LinkedList<String>();
        LinkedList<String> completions = new LinkedList<String>();
        String lastUser = existingUsers[existingUsers.length - 1];
        for (String part : value.split(",")) {
            String partTrimmed = part.trim();
            if (partTrimmed.equals(lastUser)) continue;
            usedUsers.add(partTrimmed);
        }
        String prefix = usedPrefix + ":" + String.join((CharSequence)",", usedUsers);
        AtomicInteger count = new AtomicInteger(0);
        for (Player player : Bukkit.getOnlinePlayers()) {
            String playerName = player.getName();
            if (!playerName.toLowerCase().contains(lastUser.toLowerCase()) || usedUsers.contains(playerName)) continue;
            if (usedUsers.isEmpty()) {
                completions.add(usedPrefix + ":" + playerName);
            } else {
                completions.add(prefix + "," + playerName);
            }
            count.getAndIncrement();
            if (count.get() < 10) continue;
            break;
        }
        if (completions.isEmpty()) {
            if (usedUsers.isEmpty()) {
                return Collections.singletonList(usedPrefix + ":" + lastUser);
            }
            return Collections.singletonList(prefix + "," + lastUser);
        }
        return completions;
    }

    public static class ArgumentParser {
        private final Set<ArgumentType> usedArguments = new HashSet<ArgumentType>();

        public void parseExistingArguments(String[] arguments) {
            this.usedArguments.clear();
            for (String arg : arguments) {
                String prefix;
                ArgumentType type;
                if (!arg.contains(":") || (type = ArgumentType.fromPrefix(prefix = arg.split(":", 2)[0])) == null) continue;
                this.usedArguments.add(type);
            }
        }

        public boolean isArgumentUsed(ArgumentType type) {
            return this.usedArguments.contains((Object)type);
        }

        public Set<ArgumentType> getUsedArguments() {
            return new HashSet<ArgumentType>(this.usedArguments);
        }
    }

    public static enum ArgumentType {
        ACTION("a", "action"),
        TIME("t", "time"),
        RADIUS("r", "radius"),
        PAGE("p", "page"),
        USERS("u", "users");

        private final String shortPrefix;
        private final String longPrefix;

        private ArgumentType(String shortPrefix, String longPrefix) {
            this.shortPrefix = shortPrefix;
            this.longPrefix = longPrefix;
        }

        public static ArgumentType fromPrefix(String prefix) {
            for (ArgumentType type : ArgumentType.values()) {
                if (!type.matchesPrefix(prefix)) continue;
                return type;
            }
            return null;
        }

        public String getShortPrefix() {
            return this.shortPrefix;
        }

        public String getLongPrefix() {
            return this.longPrefix;
        }

        public boolean matchesPrefix(String prefix) {
            return prefix.equals(this.shortPrefix) || prefix.equals(this.longPrefix);
        }
    }
}

