/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries;

import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.utils.WorldUtils;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class LogEntry {
    protected final long playerId;
    protected final int worldId;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final int actionType;
    protected final long createdAt;

    public LogEntry(Document document) {
        this.playerId = document.containsKey("player_id") ? document.getLong("player_id") : -2L;
        this.worldId = document.getInteger("world_id");
        this.x = document.getDouble("x");
        this.y = document.getDouble("y");
        this.z = document.getDouble("z");
        this.actionType = document.getInteger("action_type");
        this.createdAt = document.getLong("created_at");
    }

    public LogEntry(ResultSet resultSet) {
        this.playerId = resultSet.getLong("player_id");
        this.worldId = resultSet.getInt("world_id");
        this.x = resultSet.getDouble("x");
        this.y = resultSet.getDouble("y");
        this.z = resultSet.getDouble("z");
        this.actionType = resultSet.getInt("action_type");
        this.createdAt = resultSet.getLong("created_at");
    }

    public LogEntry(long playerId, int actionType, int worldId, double x, double y, double z, long createdAt) {
        this.playerId = playerId;
        this.worldId = worldId;
        this.x = (double)Math.round(x * 100.0) / 100.0;
        this.y = (double)Math.round(y * 100.0) / 100.0;
        this.z = (double)Math.round(z * 100.0) / 100.0;
        this.actionType = actionType;
        this.createdAt = createdAt;
    }

    public LogEntry(long playerId, int actionType, Location location, long createdAt) {
        this.playerId = playerId;
        this.actionType = actionType;
        this.worldId = WorldUtils.getShortId(location.getWorld().getName());
        this.x = (double)Math.round(location.getX() * 100.0) / 100.0;
        this.y = (double)Math.round(location.getY() * 100.0) / 100.0;
        this.z = (double)Math.round(location.getZ() * 100.0) / 100.0;
        this.createdAt = createdAt;
    }

    public LocationCache asLocation() {
        return LocationCache.of(this.worldId, (int)this.x, (int)this.y, (int)this.z);
    }

    public Location asBukkitLocation() {
        return new Location(Bukkit.getWorld((String)WorldUtils.getWorld(this.worldId)), this.x, this.y, this.z);
    }

    public String toString() {
        return "LogEntry{worldId=" + this.worldId + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", actionType=" + this.actionType + ", created_at=" + this.createdAt + '}';
    }

    public String getDataString() {
        return "";
    }

    public String toSaveJson() {
        return "";
    }

    @Generated
    public long getPlayerId() {
        return this.playerId;
    }

    @Generated
    public int getWorldId() {
        return this.worldId;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public int getActionType() {
        return this.actionType;
    }

    @Generated
    public long getCreatedAt() {
        return this.createdAt;
    }
}

