/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.economy;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.enums.MoneyVarType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.utils.StringCleanerUtils;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerEconomyEntry
extends LogEntry {
    private final MoneyVarType variationType;
    private final double difference;

    public PlayerEconomyEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.variationType = MoneyVarType.getById(jsonObject.get("v").getAsInt());
        this.difference = StringCleanerUtils.limitTo2Decimals(jsonObject.get("d").getAsDouble());
    }

    public PlayerEconomyEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.variationType = MoneyVarType.getById(jsonObject.get("v").getAsInt());
        this.difference = StringCleanerUtils.limitTo2Decimals(jsonObject.get("d").getAsDouble());
    }

    public PlayerEconomyEntry(long playerId, Location location, MoneyVarType variationType, double difference) {
        super(playerId, ActionType.MONEY.getId(), location, System.currentTimeMillis());
        this.variationType = variationType;
        this.difference = difference;
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerEconomyEntry entry = this;
        obj.addProperty("v", (Number)entry.getVariationType().getId());
        obj.addProperty("d", (Number)entry.getDifference());
        return obj.toString();
    }

    @Generated
    public MoneyVarType getVariationType() {
        return this.variationType;
    }

    @Generated
    public double getDifference() {
        return this.difference;
    }
}

