/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.items.ItemReference;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerItemLogEntry
extends LogEntry {
    private final long itemReferenceId;
    private final int amount;

    public PlayerItemLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.itemReferenceId = jsonObject.has("id") ? jsonObject.get("id").getAsLong() : jsonObject.get("it64").getAsLong();
        this.amount = jsonObject.has("a") ? jsonObject.get("a").getAsInt() : 1;
    }

    public PlayerItemLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.itemReferenceId = jsonObject.has("id") ? jsonObject.get("id").getAsLong() : jsonObject.get("it64").getAsLong();
        this.amount = jsonObject.has("a") ? jsonObject.get("a").getAsInt() : 1;
    }

    public PlayerItemLogEntry(long playerId, ItemReference itemReference, Location location, ActionType actionType) {
        super(playerId, actionType.getId(), location, System.currentTimeMillis());
        this.itemReferenceId = itemReference.getTemplateId();
        this.amount = itemReference.getAmount();
    }

    @Override
    public String getDataString() {
        ItemTemplate itemTemplate = StellarProtect.getInstance().getItemsManager().getItemTemplate(this.itemReferenceId);
        return itemTemplate.getBukkitItem().getType().name();
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerItemLogEntry entry = this;
        obj.addProperty("id", (Number)entry.getItemReferenceId());
        obj.addProperty("a", (Number)entry.getAmount());
        return obj.toString();
    }

    @Generated
    public long getItemReferenceId() {
        return this.itemReferenceId;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }
}

