/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerSessionEntry
extends LogEntry {
    private final byte login;
    private final long sessionTime;

    public PlayerSessionEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.login = jsonObject.get("s").getAsByte();
        this.sessionTime = jsonObject.has("t") ? jsonObject.get("t").getAsLong() : 0L;
    }

    public PlayerSessionEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.login = jsonObject.get("s").getAsByte();
        this.sessionTime = jsonObject.has("t") ? jsonObject.get("t").getAsLong() : 0L;
    }

    public PlayerSessionEntry(long playerId, Location location, byte login, long sessionTime) {
        super(playerId, ActionType.SESSION.getId(), location, System.currentTimeMillis());
        this.login = login;
        this.sessionTime = sessionTime;
    }

    @Override
    public String getDataString() {
        return String.valueOf(this.login);
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerSessionEntry entry = this;
        obj.addProperty("s", (Number)entry.getLogin());
        if (entry.getSessionTime() != 0L) {
            obj.addProperty("t", (Number)entry.getSessionTime());
        }
        return obj.toString();
    }

    @Generated
    public byte getLogin() {
        return this.login;
    }

    @Generated
    public long getSessionTime() {
        return this.sessionTime;
    }
}

