/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.enums.TeleportType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerTeleportLogEntry
extends LogEntry {
    private final float yaw;
    private final float pitch;
    private final int teleportType;

    public PlayerTeleportLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.yaw = jsonObject.has("y") ? jsonObject.get("y").getAsFloat() : 0.0f;
        this.pitch = jsonObject.has("p") ? jsonObject.get("p").getAsFloat() : 0.0f;
        this.teleportType = jsonObject.has("t") ? jsonObject.get("t").getAsInt() : TeleportType.UNKNOWN.getId();
    }

    public PlayerTeleportLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.yaw = jsonObject.has("y") ? jsonObject.get("y").getAsFloat() : 0.0f;
        this.pitch = jsonObject.has("p") ? jsonObject.get("p").getAsFloat() : 0.0f;
        this.teleportType = jsonObject.has("t") ? jsonObject.get("t").getAsInt() : TeleportType.UNKNOWN.getId();
    }

    public PlayerTeleportLogEntry(long playerId, Location location, TeleportType teleportType) {
        super(playerId, ActionType.TELEPORT.getId(), location, System.currentTimeMillis());
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.teleportType = teleportType.getId();
    }

    @Override
    public String getDataString() {
        return TeleportType.getById(this.teleportType).name();
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerTeleportLogEntry entry = this;
        obj.addProperty("y", (Number)Float.valueOf(entry.getYaw()));
        obj.addProperty("p", (Number)Float.valueOf(entry.getPitch()));
        return obj.toString();
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public int getTeleportType() {
        return this.teleportType;
    }
}

