/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.world;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.utils.PlayerUtils;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.block.Block;

public class CropGrowLogEntry
extends LogEntry {
    private final int age;

    public CropGrowLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.age = jsonObject.has("a") ? jsonObject.get("a").getAsInt() : 0;
    }

    public CropGrowLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.age = jsonObject.has("a") ? jsonObject.get("a").getAsInt() : 0;
    }

    public CropGrowLogEntry(long playerId, Block block) {
        super(playerId, ActionType.CROP_GROW.getId(), block.getLocation(), System.currentTimeMillis());
        this.age = StellarProtect.getInstance().getProtectNMS().getAge(block);
    }

    public CropGrowLogEntry(Block block) {
        super(PlayerUtils.getEntityByDirectId("=natural"), ActionType.CROP_GROW.getId(), block.getLocation(), System.currentTimeMillis());
        this.age = StellarProtect.getInstance().getProtectNMS().getAge(block);
    }

    @Override
    public String toSaveJson() {
        if (this.getAge() == 0) {
            return "";
        }
        JsonObject obj = new JsonObject();
        CropGrowLogEntry entry = this;
        obj.addProperty("a", (Number)entry.getAge());
        return obj.toString();
    }

    @Generated
    public int getAge() {
        return this.age;
    }
}

