/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.DatabaseConnection;
import io.github.InsiderAnh.StellarProtect.database.repositories.IdsRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.ItemsRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.LoggerRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.PlayerRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.RestoreRepository;
import io.github.InsiderAnh.StellarProtect.database.types.mongo.IdsRepositoryMongo;
import io.github.InsiderAnh.StellarProtect.database.types.mongo.ItemsRepositoryMongo;
import io.github.InsiderAnh.StellarProtect.database.types.mongo.LoggerRepositoryMongo;
import io.github.InsiderAnh.StellarProtect.database.types.mongo.PlayerRepositoryMongo;
import io.github.InsiderAnh.StellarProtect.database.types.mongo.RestoreRepositoryMongo;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.ConnectionString;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoClient;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoClients;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.IndexOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Indexes;
import lombok.Generated;

public class MongoConnection
implements DatabaseConnection {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private MongoClient mongoClient;
    private MongoCollection<Document> logEntries;
    private PlayerRepository playerRepository;
    private LoggerRepository loggerRepository;
    private IdsRepository idsRepository;
    private ItemsRepository itemsRepository;
    private RestoreRepository restoreRepository;

    @Override
    public void connect() {
        String connectionString = "mongodb://" + this.stellarProtect.getConfig().getString("databases.mongodb.user") + ":" + this.stellarProtect.getConfig().getString("databases.mongodb.password") + "@" + this.stellarProtect.getConfig().getString("databases.mongodb.host") + ":" + this.stellarProtect.getConfig().getInt("databases.mongodb.port");
        try {
            this.mongoClient = MongoClients.create(new ConnectionString(connectionString));
            MongoDatabase database = this.mongoClient.getDatabase(this.stellarProtect.getConfig().getString("databases.mongodb.database", "StellarProtect"));
            this.logEntries = database.getCollection(this.stellarProtect.getConfigManager().getTablesLogEntries());
            this.playerRepository = new PlayerRepositoryMongo(database);
            this.loggerRepository = new LoggerRepositoryMongo(database);
            this.idsRepository = new IdsRepositoryMongo(database);
            this.itemsRepository = new ItemsRepositoryMongo(database);
            this.restoreRepository = new RestoreRepositoryMongo(database);
            this.stellarProtect.getLogger().info("Connected to Mongo database correctly.");
        }
        catch (Exception exception) {
            this.stellarProtect.getLogger().warning("Error on connect to Mongo database.");
        }
    }

    @Override
    public void createIndexes() {
        MongoCollection<Document> collection = this.logEntries;
        collection.createIndex(Indexes.compoundIndex(Indexes.descending("created_at"), Indexes.ascending("action_type"), Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z"), Indexes.ascending("player_id")));
        collection.createIndex(Indexes.compoundIndex(Indexes.ascending("created_at"), Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z"), Indexes.ascending("action_type")), new IndexOptions().background(true));
        collection.createIndex(Indexes.compoundIndex(Indexes.ascending("action_type"), Indexes.ascending("created_at"), Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z")), new IndexOptions().background(true));
        collection.createIndex(Indexes.compoundIndex(Indexes.ascending("player_id"), Indexes.ascending("created_at")), new IndexOptions().background(true));
        collection.createIndex(Indexes.compoundIndex(Indexes.ascending("world_id"), Indexes.ascending("created_at")), new IndexOptions().background(true));
    }

    @Override
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Generated
    public StellarProtect getStellarProtect() {
        return this.stellarProtect;
    }

    @Generated
    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    @Generated
    public MongoCollection<Document> getLogEntries() {
        return this.logEntries;
    }

    @Override
    @Generated
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    @Generated
    public LoggerRepository getLoggerRepository() {
        return this.loggerRepository;
    }

    @Override
    @Generated
    public IdsRepository getIdsRepository() {
        return this.idsRepository;
    }

    @Override
    @Generated
    public ItemsRepository getItemsRepository() {
        return this.itemsRepository;
    }

    @Override
    @Generated
    public RestoreRepository getRestoreRepository() {
        return this.restoreRepository;
    }
}

