/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.enums;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum MinecraftVersion {
    v1_8,
    v1_9,
    v1_10,
    v1_11,
    v1_12,
    v1_13,
    v1_14,
    v1_15,
    v1_16,
    v1_17,
    v1_18_R1,
    v1_18_R2,
    v1_19_R1,
    v1_19_R2,
    v1_19_R3,
    v1_20_R1,
    v1_20_R2,
    v1_20_R3,
    v1_20_R4,
    v1_20(false),
    v1_21_R1("1.21.1-R0.1-SNAPSHOT"),
    v1_21_R2("1.21.2-R0.1-SNAPSHOT"),
    v1_21_R3("1.21.3-R0.1-SNAPSHOT"),
    v1_21_R4("1.21.4-R0.1-SNAPSHOT"),
    v1_21_R5("1.21.5-R0.1-SNAPSHOT"),
    v1_21_R6("1.21.6-R0.1-SNAPSHOT"),
    v1_21_R7("1.21.7-R0.1-SNAPSHOT"),
    v1_21_R8("1.21.8-R0.1-SNAPSHOT"),
    v1_21(false),
    v1_22;

    private final Set<String> versions;
    private final boolean implemented;

    private MinecraftVersion() {
        this(true);
    }

    private MinecraftVersion(boolean implemented) {
        this.implemented = implemented;
        this.versions = new HashSet<String>();
    }

    private MinecraftVersion(String ... versions) {
        this.implemented = true;
        this.versions = new HashSet<String>(Arrays.asList(versions));
    }

    private MinecraftVersion(boolean implemented, String ... versions) {
        this.implemented = implemented;
        this.versions = new HashSet<String>(Arrays.asList(versions));
    }

    public static MinecraftVersion get(String v) {
        String replaced = v.replace('.', '_');
        for (MinecraftVersion k : MinecraftVersion.values()) {
            if (!replaced.startsWith(k.name()) && !replaced.startsWith(k.name().substring(1)) && !k.versions.contains(v)) continue;
            return k;
        }
        return null;
    }

    public boolean greaterThanOrEqualTo(MinecraftVersion other) {
        return this.ordinal() >= other.ordinal();
    }

    public boolean lessThanOrEqualTo(MinecraftVersion other) {
        return this.ordinal() <= other.ordinal();
    }
}

