/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.inspect;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.economy.PlayerEconomyEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.economy.PlayerXPEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.items.ItemLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerGameModeLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerMountEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerSessionEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerShootEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerSignChangeEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerTransactionEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.items.MinecraftItem;
import io.github.InsiderAnh.StellarProtect.utils.LocationUtils;
import io.github.InsiderAnh.StellarProtect.utils.StringCleanerUtils;
import io.github.InsiderAnh.StellarProtect.utils.TimeUtils;
import io.github.InsiderAnh.StellarProtect.utils.TooltipUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InspectHandler {
    private final StellarProtect plugin = StellarProtect.getInstance();

    public void handleChestInspection(Player player, Location blockLocation, int page, int skip, int limit) {
        this.plugin.getProtectDatabase().getChestTransactions(blockLocation, skip, limit).thenAccept(callbackLookup -> {
            int maxPage = (int)Math.ceil((double)((Long)callbackLookup.getTotal()).longValue() / (double)limit);
            List logs = (List)callbackLookup.getLogs();
            if (logs.isEmpty()) {
                this.sendNoLogsMessage(player, blockLocation);
                return;
            }
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.actions.transactions_title", text -> text.replace("<location>", LocationUtils.getFormattedStringLocation(blockLocation)));
            logs.forEach(transaction -> this.processItemTransaction(player, (ItemLogEntry)transaction));
            this.sendPaginationInfo(player, page, limit, maxPage);
        });
    }

    public void handleBlockInspection(Player player, Location blockLocation, int page, int skip, int limit) {
        this.plugin.getProtectDatabase().getLogs(blockLocation, skip, limit).thenAccept(callbackLookup -> {
            int maxPage = (int)Math.ceil((double)((Long)callbackLookup.getTotal()).longValue() / (double)limit);
            Set logs = (Set)callbackLookup.getLogs();
            if (logs.isEmpty()) {
                this.sendNoLogsMessage(player, blockLocation);
                return;
            }
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.actions.location", text -> text.replace("<location>", LocationUtils.getFormattedStringLocation(blockLocation)));
            logs.forEach(logEntry -> this.processLogEntry(player, (LogEntry)logEntry));
            this.sendPaginationInfo(player, page, limit, maxPage);
        });
    }

    public void processItemTransaction(Player player, ItemLogEntry transaction) {
        ItemStack item = transaction.getItemStack();
        if (item == null) {
            return;
        }
        String messageKey = transaction.isAdded() ? "messages.actions.added_item" : "messages.actions.removed_item";
        MinecraftItem minecraftItem = StringCleanerUtils.parseMinecraftData(item.getType().name());
        this.plugin.getLangManager().sendMessage((CommandSender)player, messageKey, text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(transaction.getCreatedAt())).replace("<player>", PlayerCache.getName(transaction.getPlayerId())).replace("<data>", minecraftItem.getCleanName()).replace("<amount>", String.valueOf(transaction.getAmount())));
    }

    public void processLogEntry(Player player, LogEntry logEntry) {
        if (logEntry == null) {
            return;
        }
        ActionType actionType = ActionType.getById(logEntry.getActionType());
        if (actionType == null) {
            return;
        }
        ActionHandler handler = ActionHandlerFactory.getHandler(actionType);
        if (handler != null) {
            handler.handle(player, logEntry, this.plugin);
        } else {
            this.handleGenericAction(player, logEntry, actionType);
        }
    }

    public void handleGenericAction(Player player, LogEntry logEntry, ActionType actionType) {
        MinecraftItem minecraftItem = StringCleanerUtils.parseMinecraftData(logEntry.getDataString());
        this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.actions." + actionType.name().toLowerCase(), text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())).replace("<data>", minecraftItem.getCleanName()));
    }

    public void sendNoLogsMessage(Player player, Location blockLocation) {
        this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noInspectLogs", text -> text.replace("<location>", LocationUtils.getFormattedStringLocation(blockLocation)));
    }

    public void sendPaginationInfo(Player player, int currentPage, int itemsPerPage, long total) {
        this.plugin.getProtectNMS().sendPageButtons(player, this.plugin.getLangManager().get("messages.pagesNav"), this.plugin.getLangManager().get("messages.clickPage"), currentPage, itemsPerPage, (int)total);
    }

    public static class ActionHandlerFactory {
        private static final Map<ActionType, ActionHandler> handlers = new HashMap<ActionType, ActionHandler>();

        public static ActionHandler getHandler(ActionType actionType) {
            return handlers.get((Object)actionType);
        }

        static {
            handlers.put(ActionType.SESSION, new SessionActionHandler());
            handlers.put(ActionType.SIGN_CHANGE, new SignChangeActionHandler());
            handlers.put(ActionType.INVENTORY_TRANSACTION, new InventoryTransactionActionHandler());
            handlers.put(ActionType.MOUNT, new MountActionHandler());
            handlers.put(ActionType.SHOOT, new ShootActionHandler());
            handlers.put(ActionType.GAME_MODE, new GameModeActionHandler());
            handlers.put(ActionType.XP, new XPActionHandler());
            handlers.put(ActionType.MONEY, new EconomyActionHandler());
        }
    }

    public static interface ActionHandler {
        public void handle(Player var1, LogEntry var2, StellarProtect var3);
    }

    public static class SignChangeActionHandler
    implements ActionHandler {
        @Override
        public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
            PlayerSignChangeEntry signEntry = (PlayerSignChangeEntry)logEntry;
            plugin.getProtectNMS().sendActionTitle(player, plugin.getLangManager().get("messages.actions.sign_change"), plugin.getLangManager().get("messages.tooltips.sign_change"), "", text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())).replace("<line1>", signEntry.getLine(0)).replace("<line2>", signEntry.getLine(1)).replace("<line3>", signEntry.getLine(2)).replace("<line4>", signEntry.getLine(3)));
        }
    }

    public static class GameModeActionHandler
    implements ActionHandler {
        @Override
        public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
            PlayerGameModeLogEntry gameModeEntry = (PlayerGameModeLogEntry)logEntry;
            plugin.getProtectNMS().sendActionTitle(player, plugin.getLangManager().get("messages.actions.game_mode"), plugin.getLangManager().get("messages.tooltips.game_mode"), "", text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())).replace("<lastGameMode>", String.valueOf(gameModeEntry.getLastGameMode())).replace("<newGameMode>", String.valueOf(gameModeEntry.getNewGameMode())));
        }
    }

    public static class MountActionHandler
    implements ActionHandler {
        @Override
        public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
            MinecraftItem minecraftItem = StringCleanerUtils.parseMinecraftData(logEntry.getDataString());
            PlayerMountEntry sessionEntry = (PlayerMountEntry)logEntry;
            String login = sessionEntry.getMount() == 1 ? "dismount" : "mount";
            plugin.getLangManager().sendMessage((CommandSender)player, "messages.actions." + login, text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())).replace("<data>", minecraftItem.getCleanName()));
        }
    }

    public static class ShootActionHandler
    implements ActionHandler {
        @Override
        public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
            MinecraftItem minecraftItem = StringCleanerUtils.parseMinecraftData(logEntry.getDataString());
            PlayerShootEntry sessionEntry = (PlayerShootEntry)logEntry;
            String login = sessionEntry.getSuccess() == 1 ? "success_shoot" : "shoot";
            plugin.getLangManager().sendMessage((CommandSender)player, "messages.actions." + login, text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())).replace("<shoot>", sessionEntry.getShootEntityType()).replace("<data>", minecraftItem.getCleanName()));
        }
    }

    public static class SessionActionHandler
    implements ActionHandler {
        @Override
        public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
            PlayerSessionEntry sessionEntry = (PlayerSessionEntry)logEntry;
            if (sessionEntry.getLogin() == 1) {
                plugin.getLangManager().sendMessage((CommandSender)player, "messages.actions.login_session", text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())));
            } else {
                plugin.getProtectNMS().sendActionTitle(player, plugin.getLangManager().get("messages.actions.logout_session"), plugin.getLangManager().get("messages.tooltips.logout_session").replace("<time>", TimeUtils.formatMillisAsCompactDHMS(sessionEntry.getSessionTime() * 1000L)), "", text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())));
            }
        }
    }

    public static class InventoryTransactionActionHandler
    implements ActionHandler {
        @Override
        public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
            PlayerTransactionEntry inventoryTransactionEntry = (PlayerTransactionEntry)logEntry;
            plugin.getProtectNMS().sendActionTitle(player, plugin.getLangManager().get("messages.actions.inventory_transaction"), plugin.getLangManager().get("messages.tooltips.inventory_transaction").replace("<added>", TooltipUtils.getTooltipAdded(inventoryTransactionEntry.getAdded())).replace("<removed>", TooltipUtils.getTooltipRemoved(inventoryTransactionEntry.getRemoved())), "", text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())).replace("<added>", String.valueOf(inventoryTransactionEntry.getAdded().size())).replace("<removed>", String.valueOf(inventoryTransactionEntry.getRemoved().size())));
        }
    }

    public static class EconomyActionHandler
    implements ActionHandler {
        @Override
        public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
            PlayerEconomyEntry economyEntry = (PlayerEconomyEntry)logEntry;
            String messageKey = economyEntry.getVariationType().name().toLowerCase() + "_" + (economyEntry.getDifference() > 0.0 ? "income" : "outcome");
            plugin.getLangManager().sendMessage((CommandSender)player, "messages.actions." + messageKey, text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())).replace("<amount>", StringCleanerUtils.formatEconomy(economyEntry.getDifference())));
        }
    }

    public static class XPActionHandler
    implements ActionHandler {
        @Override
        public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
            PlayerXPEntry xpEntry = (PlayerXPEntry)logEntry;
            plugin.getLangManager().sendMessage((CommandSender)player, "messages.actions." + (xpEntry.getDifference() > 0.0 ? "add_xp" : "remove_xp"), text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerCache.getName(logEntry.getPlayerId())).replace("<amount>", String.valueOf(xpEntry.getDifference())));
        }
    }
}

