/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoCompressor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoDriverInformation;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ServerId;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.StreamFactory;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.event.CommandListener;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.Authenticator;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.ClientMetadataHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.DefaultAuthenticator;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.GSSAPIAuthenticator;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.InternalConnection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.InternalConnectionFactory;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.InternalStreamConnection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.InternalStreamConnectionInitializer;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.NativeAuthenticator;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.PlainAuthenticator;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.ScramShaAuthenticator;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.X509Authenticator;
import java.util.ArrayList;
import java.util.List;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final StreamFactory streamFactory;
    private final BsonDocument clientMetadataDocument;
    private final List<Authenticator> authenticators;
    private final List<MongoCompressor> compressorList;
    private final CommandListener commandListener;

    InternalStreamConnectionFactory(StreamFactory streamFactory, List<MongoCredentialWithCache> credentialList, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, CommandListener commandListener) {
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.commandListener = commandListener;
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        Assertions.notNull("credentialList", credentialList);
        this.authenticators = new ArrayList<Authenticator>(credentialList.size());
        for (MongoCredentialWithCache credential : credentialList) {
            this.authenticators.add(this.createAuthenticator(credential));
        }
    }

    @Override
    public InternalConnection create(ServerId serverId) {
        return new InternalStreamConnection(serverId, this.streamFactory, this.compressorList, this.commandListener, new InternalStreamConnectionInitializer(this.authenticators, this.clientMetadataDocument, this.compressorList));
    }

    private Authenticator createAuthenticator(MongoCredentialWithCache credential) {
        if (credential.getAuthenticationMechanism() == null) {
            return new DefaultAuthenticator(credential);
        }
        switch (credential.getAuthenticationMechanism()) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential);
            }
            case SCRAM_SHA_1: 
            case SCRAM_SHA_256: {
                return new ScramShaAuthenticator(credential);
            }
            case MONGODB_CR: {
                return new NativeAuthenticator(credential);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)credential.getAuthenticationMechanism()));
    }
}

