/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.bson.io.BsonOutput;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.BaseQueryMessage;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.MessageSettings;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.RequestMessage;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.validator.NoOpFieldNameValidator;

class QueryMessage
extends BaseQueryMessage {
    private final BsonDocument queryDocument;
    private final BsonDocument fields;

    QueryMessage(String collectionName, int skip, int numberToReturn, BsonDocument queryDocument, BsonDocument fields, MessageSettings settings) {
        super(collectionName, skip, numberToReturn, settings);
        this.queryDocument = queryDocument;
        this.fields = fields;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput) {
        this.writeQueryPrologue(bsonOutput);
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(this.queryDocument, bsonOutput, new NoOpFieldNameValidator());
        if (this.fields != null) {
            this.addDocument(this.fields, bsonOutput, new NoOpFieldNameValidator());
        }
        return new RequestMessage.EncodingMetadata(firstDocumentStartPosition);
    }
}

