/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.listeners;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerBlockLogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.utils.PlayerUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;

public class BlockFormListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFormTo(BlockFromToEvent event) {
        Block oldBlock = event.getBlock();
        Block newBlock = event.getToBlock();
        long userId = this.getEntityId(oldBlock);
        if (!oldBlock.getType().name().contains("AIR")) {
            LoggerCache.addLog(new PlayerBlockLogEntry(userId, oldBlock, ActionType.BLOCK_BREAK));
        }
        if (!newBlock.getType().name().contains("AIR")) {
            LoggerCache.addLog(new PlayerBlockLogEntry(userId, newBlock, ActionType.BLOCK_PLACE));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
    }

    private long getEntityId(Block block) {
        if (block.getType().equals((Object)Material.LAVA) || block.getType().name().equals("STATIONARY_LAVA")) {
            return PlayerUtils.getEntityByDirectId("=lava");
        }
        if (block.getType().equals((Object)Material.WATER) || block.getType().name().equals("STATIONARY_WATER")) {
            return PlayerUtils.getEntityByDirectId("=water");
        }
        LogEntry logEntry = LoggerCache.getPlacedBlockLog(block.getLocation());
        if (logEntry == null || !this.plugin.getConfigManager().isLiquidTracking()) {
            return -2L;
        }
        return logEntry.getPlayerId();
    }
}

